/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.util;

import com.mikitellurium.turtlechargingstation.common.block.CopperCableBlock;
import com.mikitellurium.turtlechargingstation.registry.ModBlocks;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CableHelper {
    private static final double MIN = 5.0;
    private static final double MAX = 11.0;
    private static final VoxelShape CABLE_CORE_SHAPE = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final Map<Direction, VoxelShape> CABLE_ARM_SHAPE = (Map)Util.m_137469_(new EnumMap(Direction.class), map -> {
        map.put(Direction.DOWN, Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0));
        map.put(Direction.UP, Block.m_49796_((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
        map.put(Direction.NORTH, Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0));
        map.put(Direction.SOUTH, Block.m_49796_((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0));
        map.put(Direction.WEST, Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0));
        map.put(Direction.EAST, Block.m_49796_((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));
    });
    private static final VoxelShape[] CABLE_SHAPES = new VoxelShape[64];

    private static int getShapeIndex(BlockState state) {
        int connections = 0;
        for (Direction dir : Direction.values()) {
            if (!((Boolean)state.m_61143_((Property)CopperCableBlock.CONNECTIONS.get(dir))).booleanValue()) continue;
            connections |= 1 << dir.ordinal();
        }
        return connections;
    }

    private static VoxelShape getShape(int index) {
        VoxelShape shape = CABLE_SHAPES[index];
        if (shape != null) {
            return shape;
        }
        shape = CABLE_CORE_SHAPE;
        for (Direction dir : Direction.values()) {
            if ((index & 1 << dir.ordinal()) == 0) continue;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CABLE_ARM_SHAPE.get(dir));
        }
        CableHelper.CABLE_SHAPES[index] = shape;
        return CableHelper.CABLE_SHAPES[index];
    }

    public static VoxelShape getCableShape(BlockState state) {
        return state.m_60713_((Block)ModBlocks.COPPER_CABLE.get()) ? CableHelper.getShape(CableHelper.getShapeIndex(state)) : Shapes.m_83040_();
    }
}

