/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation;

import com.mikitellurium.telluriumforge.event.EventHelper;
import com.mikitellurium.turtlechargingstation.common.blockentity.TurtleChargingStationBlockEntity;
import com.mikitellurium.turtlechargingstation.common.integration.computercraft.TurtleChargingStationPeripheral;
import com.mikitellurium.turtlechargingstation.datagen.ModBlockTagsProvider;
import com.mikitellurium.turtlechargingstation.datagen.ModEntityTagsProvider;
import com.mikitellurium.turtlechargingstation.datagen.ModLootTableProvider;
import com.mikitellurium.turtlechargingstation.datagen.ModRecipeProvider;
import com.mikitellurium.turtlechargingstation.registry.ModCreativeTab;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.ForgeComputerCraftAPI;
import dan200.computercraft.api.lua.GenericSource;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class CommonSetup {
    public static void register(IEventBus modEventBus) {
        EventHelper helper = new EventHelper();
        helper.addListener(modEventBus, ModCreativeTab::buildCreativeTab).addListener(modEventBus, CommonSetup::commonSetup).addListener(modEventBus, CommonSetup::gatherData).registerAll();
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        ComputerCraftAPI.registerGenericSource((GenericSource)new TurtleChargingStationPeripheral());
        ForgeComputerCraftAPI.registerGenericCapability(TurtleChargingStationBlockEntity.ACCESS_CAP);
    }

    private static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new ModRecipeProvider(generator));
        generator.addProvider(true, (DataProvider)new ModLootTableProvider.Output(generator.getPackOutput()));
        generator.addProvider(true, (DataProvider)new ModBlockTagsProvider(generator.getPackOutput(), lookupProvider, event.getExistingFileHelper()));
        generator.addProvider(true, (DataProvider)new ModEntityTagsProvider(generator.getPackOutput(), lookupProvider, event.getExistingFileHelper()));
    }
}

