/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.client.gui.element;

import com.mikitellurium.turtlechargingstation.common.blockentity.TurtleChargingStationBlockEntity;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TurtleInfoElement {
    private static final int WHITE = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    private final TurtleChargingStationBlockEntity station;
    private final Rect2i area;
    private final Map<Direction, TurtleData> turtleData = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.values()) {
            map.put(direction, new TurtleData());
        }
    });
    private final Font font;
    private int stringTimer;

    public TurtleInfoElement(TurtleChargingStationBlockEntity station, int xPos, int yPos) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.stringTimer = 0;
        this.area = new Rect2i(xPos, yPos, 166, 87);
        this.station = station;
    }

    public void draw(GuiGraphics graphics) {
        this.turtleData.forEach((direction, data) -> data.updateData(this.station, (Direction)direction));
        int xPos = this.area.m_110085_();
        int yPos = this.area.m_110086_();
        int namePos = xPos + 75;
        int fuelPos = xPos + 143;
        MutableComponent name = Component.m_237115_((String)"gui.turtlechargingstation.turtle_charging_station.turtle_name");
        MutableComponent fuelLevel = Component.m_237115_((String)"gui.turtlechargingstation.turtle_charging_station.fuel_level");
        graphics.m_280653_(this.font, (Component)name, namePos, yPos + 2, WHITE);
        graphics.m_280653_(this.font, (Component)fuelLevel, fuelPos, yPos + 2, WHITE);
        int h = yPos + 2;
        for (Direction direction2 : Direction.values()) {
            TurtleData data2 = this.turtleData.get(direction2);
            String directionName = this.getDirectionName(direction2);
            Component turtleName = this.trimLabel(data2.getLabel());
            graphics.m_280488_(this.font, directionName, this.alignString(directionName, xPos - 8), h += 12, WHITE);
            graphics.m_280653_(this.font, turtleName, namePos, h, data2.turtleColor);
            graphics.m_280137_(this.font, this.getFuelString(data2.turtleFuel), fuelPos, h, WHITE);
        }
    }

    private String getDirectionName(Direction direction) {
        String name = Component.m_237115_((String)("gui.turtlechargingstation.turtle_charging_station." + direction.m_122433_())).getString();
        String withColon = name + ":";
        int leadingSpace = 7 - withColon.length();
        return " ".repeat(Math.max(leadingSpace, 0)) + withColon;
    }

    private int alignString(String string, int xPos) {
        int width = this.font.m_92895_(string);
        return Math.max(xPos + (40 - width), xPos);
    }

    public void updateStringTimer() {
        ++this.stringTimer;
    }

    private Component trimLabel(Component component) {
        String s;
        int maxWidth = 80;
        String finalString = s = component.getString();
        if (this.font.m_92895_(s) > 80) {
            String sub = this.font.m_92834_(s, 80);
            int maxLength = sub.length();
            int excessChars = s.length() - maxLength + 2;
            int index = this.stringTimer % excessChars;
            if (index > 0) {
                --index;
            }
            finalString = s.substring(index, maxLength + index);
        }
        return Component.m_237113_((String)finalString);
    }

    private String getFuelString(int fuelLevel) {
        return fuelLevel == -1 ? "-" : String.valueOf(fuelLevel);
    }

    public Rect2i getArea() {
        return this.area;
    }

    private static class TurtleData {
        private String label = "-";
        private int turtleColor = WHITE;
        private int turtleFuel = -1;

        private TurtleData() {
        }

        private void updateData(TurtleChargingStationBlockEntity station, Direction direction) {
            Optional<TurtleBlockEntity> optional = this.getAdjacentTurtle(station, direction);
            if (optional.isPresent()) {
                TurtleBlockEntity turtle = optional.get();
                this.label = turtle.m_8077_() ? turtle.getLabel() : String.valueOf(turtle.getComputerID());
                this.turtleColor = turtle.getColour() == -1 ? WHITE : turtle.getColour();
                this.turtleFuel = turtle.getAccess().getFuelLevel();
            } else {
                this.label = "-";
                this.turtleColor = WHITE;
                this.turtleFuel = -1;
            }
        }

        private Optional<TurtleBlockEntity> getAdjacentTurtle(TurtleChargingStationBlockEntity station, Direction direction) {
            Optional<TurtleBlockEntity> optional;
            BlockEntity blockEntity = station.m_58904_().m_7702_(station.m_58899_().m_121945_(direction));
            if (blockEntity instanceof TurtleBlockEntity) {
                TurtleBlockEntity turtle = (TurtleBlockEntity)blockEntity;
                optional = Optional.of(turtle);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }

        private Component getLabel() {
            return Component.m_237113_((String)this.label);
        }
    }
}

