/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.integration.computercraft;

import com.mikitellurium.turtlechargingstation.common.block.ThunderchargeDynamoBlock;
import com.mikitellurium.turtlechargingstation.common.blockentity.ThunderchargeDynamoBlockEntity;
import com.mikitellurium.turtlechargingstation.common.capability.PeripheralProvider;
import com.mikitellurium.turtlechargingstation.util.FastLoc;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ThunderchargeDynamoPeripheral
implements IPeripheral {
    private static final ResourceLocation ID = FastLoc.ofMod("thundercharge_dynamo");
    private final ThunderchargeDynamoBlockEntity dynamo;

    public ThunderchargeDynamoPeripheral(ThunderchargeDynamoBlockEntity dynamo) {
        this.dynamo = dynamo;
    }

    @LuaFunction(mainThread=true)
    public final int getCharge() {
        return this.dynamo.getCharge();
    }

    @LuaFunction(mainThread=true)
    public final boolean isPowered() {
        return (Boolean)this.dynamo.m_58900_().m_61143_((Property)ThunderchargeDynamoBlock.POWERED);
    }

    public String getType() {
        return "thundercharge_dynamo";
    }

    public boolean equals(IPeripheral other) {
        return other instanceof ThunderchargeDynamoPeripheral && this.dynamo == ((ThunderchargeDynamoPeripheral)other).dynamo;
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof ThunderchargeDynamoBlockEntity) {
            ThunderchargeDynamoBlockEntity dynamo = (ThunderchargeDynamoBlockEntity)((Object)object);
            event.addCapability(ID, new PeripheralProvider<ThunderchargeDynamoBlockEntity>(dynamo, ThunderchargeDynamoPeripheral::new));
        }
    }
}

