/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.config;

import com.mikitellurium.turtlechargingstation.common.blockentity.ThunderchargeDynamoBlockEntity;
import com.mikitellurium.turtlechargingstation.common.blockentity.TurtleChargingStationBlockEntity;
import com.mikitellurium.turtlechargingstation.util.FastLoc;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ModConfigs {
    private static ForgeConfigSpec COMMON_CONFIG;

    public static void register() {
        ForgeConfigSpec.Builder CONFIG_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_CONFIG = ModConfigs.setupConfig(CONFIG_BUILDER);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_CONFIG);
    }

    private static ForgeConfigSpec setupConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Turtle Charging Station Configuration").push(FastLoc.modId());
        TurtleChargingStationBlockEntity.CAPACITY = builder.comment("The maximum amount of FE the charging station can hold").defineInRange("chargingStationMaxCapacity", 64000, 0, Integer.MAX_VALUE);
        TurtleChargingStationBlockEntity.CONVERSION_RATE = builder.comment("The amount of FE required to increase the turtle fuel level by 1").defineInRange("chargingStationConversionRate", 256, 0, Integer.MAX_VALUE);
        ThunderchargeDynamoBlockEntity.RECHARGE_AMOUNT = builder.comment(new String[]{"The amount of time (in ticks) that is added to the charge when the thundercharge", "dynamo is struck by lightning.", "1 minute = 1200 in-game ticks"}).defineInRange("dynamoRechargeAmount", 1200, 0, Integer.MAX_VALUE);
        ThunderchargeDynamoBlockEntity.TRANSFER_RATE = builder.comment("The amount of FE/tick generated by the thundercharge dynamo").defineInRange("dynamoTransferRate", 1024, 0, Integer.MAX_VALUE);
        builder.pop();
        return builder.build();
    }

    public static ForgeConfigSpec getCommon() {
        return COMMON_CONFIG;
    }
}

