/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.client.gui.element;

import com.mikitellurium.telluriumforge.util.Utils;
import com.mikitellurium.turtlechargingstation.common.blockentity.TurtleChargingStationTileEntity;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class TurtleInfoElement {
    private static final int WHITE = 0xFFFFFF;
    private final TurtleChargingStationTileEntity station;
    private final Rectangle area;
    private final Map<EnumFacing, TurtleData> turtleData = (Map)Utils.make(new HashMap(), map -> {
        for (EnumFacing direction : EnumFacing.values()) {
            map.put(direction, new TurtleData());
        }
    });
    private final FontRenderer font;
    private int stringTimer;

    public TurtleInfoElement(TurtleChargingStationTileEntity station, int xPos, int yPos) {
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.stringTimer = 0;
        this.area = new Rectangle(xPos, yPos, 166, 87);
        this.station = station;
    }

    public void draw(Gui parent) {
        this.turtleData.forEach((direction, data) -> ((TurtleData)data).updateData(this.station, direction));
        int xPos = this.area.x;
        int yPos = this.area.y;
        int namePos = xPos + 75;
        int fuelPos = xPos + 143;
        TextComponentTranslation name = new TextComponentTranslation("gui.turtle_charging_station.turtle_name", new Object[0]);
        TextComponentTranslation fuelLevel = new TextComponentTranslation("gui.turtle_charging_station.fuel_level", new Object[0]);
        parent.func_73732_a(this.font, name.func_150260_c(), namePos, yPos + 2, 0xFFFFFF);
        parent.func_73732_a(this.font, fuelLevel.func_150260_c(), fuelPos, yPos + 2, 0xFFFFFF);
        int h = yPos + 2;
        for (EnumFacing direction2 : EnumFacing.values()) {
            TurtleData data2 = this.turtleData.get(direction2);
            String directionName = this.getDirectionName(direction2);
            ITextComponent turtleName = this.trimLabel(data2.getLabel());
            parent.func_73731_b(this.font, directionName, this.alignString(directionName, xPos - 8), h += 12, 0xFFFFFF);
            parent.func_73732_a(this.font, turtleName.func_150260_c(), namePos, h, data2.turtleColor);
            parent.func_73732_a(this.font, this.getFuelString(data2.turtleFuel), fuelPos, h, 0xFFFFFF);
        }
    }

    private String getDirectionName(EnumFacing direction) {
        String name = new TextComponentTranslation("gui.turtle_charging_station." + direction.func_176610_l(), new Object[0]).func_150260_c();
        String withColon = name + ":";
        int leadingSpace = 7 - withColon.length();
        return String.join((CharSequence)"", Collections.nCopies(Math.max(leadingSpace, 0), " ")) + withColon;
    }

    private int alignString(String string, int xPos) {
        int width = this.font.func_78256_a(string);
        return Math.max(xPos + (40 - width), xPos);
    }

    public void updateStringTimer() {
        ++this.stringTimer;
    }

    private ITextComponent trimLabel(ITextComponent text) {
        String s;
        int maxWidth = 80;
        String finalString = s = text.func_150260_c();
        if (this.font.func_78256_a(s) > 80) {
            String sub = this.font.func_78269_a(s, 80);
            int maxLength = sub.length();
            int excessChars = s.length() - maxLength + 2;
            int index = this.stringTimer % excessChars;
            if (index > 0) {
                --index;
            }
            finalString = s.substring(index, maxLength + index);
        }
        return new TextComponentString(finalString);
    }

    private String getFuelString(int fuelLevel) {
        return fuelLevel == -1 ? "-" : String.valueOf(fuelLevel);
    }

    public Rectangle getArea() {
        return this.area;
    }

    private static class TurtleData {
        private String label = "-";
        private int turtleColor = 0xFFFFFF;
        private int turtleFuel = -1;

        private TurtleData() {
        }

        private void updateData(TurtleChargingStationTileEntity station, EnumFacing direction) {
            Optional<TileTurtle> optional = this.getAdjacentTurtle(station, direction);
            if (optional.isPresent()) {
                TileTurtle turtle = optional.get();
                this.label = turtle.func_145818_k_() ? turtle.getLabel() : String.valueOf(turtle.getComputerID());
                this.turtleColor = turtle.getColour() == -1 ? 0xFFFFFF : turtle.getColour();
                this.turtleFuel = turtle.getAccess().getFuelLevel();
            } else {
                this.label = "-";
                this.turtleColor = 0xFFFFFF;
                this.turtleFuel = -1;
            }
        }

        private Optional<TileTurtle> getAdjacentTurtle(TurtleChargingStationTileEntity station, EnumFacing direction) {
            TileEntity tile = station.func_145831_w().func_175625_s(station.func_174877_v().func_177972_a(direction));
            return tile instanceof TileTurtle ? Optional.of((TileTurtle)tile) : Optional.empty();
        }

        private ITextComponent getLabel() {
            return new TextComponentString(this.label);
        }
    }
}

