/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.integration.computercraft;

import com.mikitellurium.turtlechargingstation.common.block.TurtleChargingStationBlock;
import com.mikitellurium.turtlechargingstation.common.blockentity.TurtleChargingStationTileEntity;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class TurtleChargingStationPeripheral
implements IPeripheral {
    private final TurtleChargingStationTileEntity tile;

    public TurtleChargingStationPeripheral(TurtleChargingStationTileEntity tile) {
        this.tile = tile;
    }

    @Nonnull
    public String getType() {
        return "turtle_charging_station";
    }

    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"isEnabled", "isCharging", "getSide", "getSides", "getEnergy", "getEnergyCapacity", "getItemDetail"};
    }

    @Nullable
    public Object[] callMethod(@Nonnull IComputerAccess iComputerAccess, @Nonnull ILuaContext iLuaContext, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
        TurtleChargingStationTileEntity.CCAccess access = this.tile.getAccess();
        switch (method) {
            case 0: {
                return this.isEnabled(access);
            }
            case 1: {
                return this.isCharging(access);
            }
            case 2: {
                EnumFacing side = EnumFacing.func_176739_a((String)arguments[0].toString());
                if (side == null) {
                    throw new LuaException("Invalid side: " + arguments[0]);
                }
                return this.getSide(access, side);
            }
            case 3: {
                return this.getSides(access);
            }
            case 4: {
                return this.ret(this.tile.getEnergy());
            }
            case 5: {
                return this.ret(this.tile.getMaxEnergy());
            }
            case 6: {
                return this.getItemDetail(this.tile.getItemHandler().getStackInSlot(0));
            }
        }
        return null;
    }

    public Object[] isEnabled(TurtleChargingStationTileEntity.CCAccess access) {
        return this.ret(access.getBlockState().func_177229_b((IProperty)TurtleChargingStationBlock.ENABLED));
    }

    public Object[] isCharging(TurtleChargingStationTileEntity.CCAccess access) {
        IBlockState blockState = access.getBlockState();
        return this.ret((Boolean)blockState.func_177229_b((IProperty)TurtleChargingStationBlock.ENABLED) != false && (Boolean)blockState.func_177229_b((IProperty)TurtleChargingStationBlock.CHARGING) != false);
    }

    public Object[] getSide(TurtleChargingStationTileEntity.CCAccess access, EnumFacing side) {
        Optional<Object> optional = this.getSideData(access.getWorld(), access.getPos(), side);
        return optional.map(xva$0 -> this.ret(xva$0)).orElse(null);
    }

    public Object[] getSides(TurtleChargingStationTileEntity.CCAccess access) {
        HashMap results = new HashMap();
        for (EnumFacing direction : EnumFacing.values()) {
            Optional<Object> optional = this.getSideData(access.getWorld(), access.getPos(), direction);
            optional.ifPresent(obj -> results.put(direction.func_176610_l(), obj));
        }
        return !results.isEmpty() ? this.ret(results) : null;
    }

    private Optional<Object> getSideData(World world, BlockPos pos, EnumFacing side) {
        TileEntity tile1 = world.func_175625_s(pos.func_177972_a(side));
        if (tile1 instanceof TileTurtle) {
            TileTurtle turtle = (TileTurtle)tile1;
            String label = turtle.func_145818_k_() ? turtle.getLabel() : String.valueOf(turtle.getComputerID());
            HashMap<String, Object> sides = new HashMap<String, Object>();
            sides.put("name", label);
            sides.put("fuelLevel", turtle.getAccess().getFuelLevel());
            return Optional.of(sides);
        }
        return Optional.empty();
    }

    private Object[] getItemDetail(ItemStack stack) {
        if (stack.func_190926_b()) {
            return this.ret(new Object[]{null});
        }
        Item item = stack.func_77973_b();
        String name = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString();
        HashMap<String, Object> table = new HashMap<String, Object>();
        table.put("name", name);
        table.put("damage", stack.func_77952_i());
        table.put("count", stack.func_190916_E());
        return this.ret(table);
    }

    private Object[] ret(Object ... objects) {
        return objects;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof TurtleChargingStationPeripheral && this.tile == ((TurtleChargingStationPeripheral)other).tile;
    }
}

