/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.blockentity;

import com.mikitellurium.telluriumforge.blockentity.TickingBlockEntity;
import com.mikitellurium.telluriumforge.networking.NetworkingHelper;
import com.mikitellurium.turtlechargingstation.common.block.CopperCableBlock;
import com.mikitellurium.turtlechargingstation.common.energy.CableNetwork;
import com.mikitellurium.turtlechargingstation.common.energy.CableNetworkImpl;
import com.mikitellurium.turtlechargingstation.common.energy.NetworkNode;
import com.mikitellurium.turtlechargingstation.networking.packets.CableIdSyncPacket;
import com.mikitellurium.turtlechargingstation.registry.ModBlockEntities;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import team.reborn.energy.api.EnergyStorage;

public class CopperCableBlockEntity
extends class_2586
implements TickingBlockEntity,
NetworkNode {
    private CableNetwork cableNetwork;
    private boolean ignoreOnUpdate = false;
    private int burningTimer = 0;
    private boolean firstTick = true;
    private int clientNetworkId = -1;

    public CopperCableBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockEntities.COPPER_CABLE, pos, blockState);
    }

    public void tick(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        if (this.firstTick) {
            this.updateConnections();
            this.firstTick = false;
        }
        super.tick(world, blockPos, blockState);
    }

    public void serverTick(class_3218 level, class_2338 blockPos, class_2680 blockState) {
        if (this.burningTimer > 0) {
            if (!((Boolean)blockState.method_11654((class_2769)CopperCableBlock.BURNING)).booleanValue()) {
                level.method_8501(blockPos, (class_2680)blockState.method_11657((class_2769)CopperCableBlock.BURNING, (Comparable)Boolean.valueOf(true)));
            }
            --this.burningTimer;
        } else if (((Boolean)blockState.method_11654((class_2769)CopperCableBlock.BURNING)).booleanValue()) {
            level.method_8501(blockPos, (class_2680)blockState.method_11657((class_2769)CopperCableBlock.BURNING, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void setBurning() {
        this.burningTimer = 200;
    }

    public void updateConnections() {
        if (this.field_11863.field_9236) {
            return;
        }
        Set<CopperCableBlockEntity> cableSet = this.getAdjacentCables();
        if (!cableSet.isEmpty()) {
            this.joinNetwork(cableSet);
        }
        if (!this.hasNetwork()) {
            this.setNetwork(new CableNetworkImpl(this));
        }
    }

    private void joinNetwork(Set<CopperCableBlockEntity> cableSet) {
        cableSet.stream().filter(CopperCableBlockEntity::hasNetwork).map(CopperCableBlockEntity::getNetwork).max(Comparator.comparingInt(CableNetwork::size)).ifPresent(network -> network.update(this));
    }

    public void remove() {
        if (this.field_11863.field_9236) {
            return;
        }
        this.cableNetwork.removeNode(this);
        this.ignoreOnUpdate = true;
        Set<CopperCableBlockEntity> cableSet = this.getAdjacentCables();
        ArrayList cachedNetworks = new ArrayList();
        cableSet.forEach(cable -> {
            if (cable.hasNetwork() && !cachedNetworks.contains(cable.getNetwork())) {
                CableNetworkImpl newNetwork = new CableNetworkImpl((NetworkNode)cable);
                cachedNetworks.add(newNetwork);
                cable.setNetwork(newNetwork);
                cable.getNetwork().update((NetworkNode)cable);
            }
        });
    }

    public Set<CopperCableBlockEntity> getAdjacentCables() {
        HashSet<CopperCableBlockEntity> cableSet = new HashSet<CopperCableBlockEntity>();
        for (class_2350 direction : class_2350.values()) {
            class_2338 relativePos = this.field_11867.method_10093(direction);
            class_2586 blockEntity = this.field_11863.method_8321(relativePos);
            if (!(blockEntity instanceof CopperCableBlockEntity)) continue;
            CopperCableBlockEntity cable = (CopperCableBlockEntity)blockEntity;
            if (cable.ignoreOnUpdate) continue;
            cableSet.add(cable);
        }
        return cableSet;
    }

    @Override
    public boolean hasNetwork() {
        return this.cableNetwork != null;
    }

    @Override
    public CableNetwork getNetwork() {
        return this.cableNetwork;
    }

    @Override
    public void setNetwork(CableNetwork cableNetwork) {
        Objects.requireNonNull(cableNetwork);
        this.cableNetwork = cableNetwork;
        this.syncClientId();
    }

    @Override
    public boolean ignoreOnUpdate() {
        return this.ignoreOnUpdate;
    }

    @Override
    public class_1937 getNodeWorld() {
        return this.field_11863;
    }

    @Override
    public class_2338 getBlockPos() {
        return this.field_11867;
    }

    public EnergyStorage energyLookup(class_2350 side) {
        return EnergyStorage.EMPTY;
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        nbt.method_10569("networkId", this.cableNetwork != null ? ((CableNetworkImpl)this.cableNetwork).getId() : this.clientNetworkId);
        return nbt;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.burningTimer = nbt.method_10550("burningTimer");
        if (nbt.method_10545("networkId")) {
            this.setClientNetworkId(nbt.method_10550("networkId"));
        }
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10569("burningTimer", this.burningTimer);
        super.method_11007(nbt);
    }

    public void setClientNetworkId(int id) {
        this.clientNetworkId = id;
    }

    public int getClientNetworkId() {
        return this.field_11863.field_9236 ? this.clientNetworkId : -2;
    }

    private void syncClientId() {
        if (FabricLoaderImpl.INSTANCE.isDevelopmentEnvironment() && !this.field_11863.field_9236) {
            NetworkingHelper.sendToTrackingClients((class_3218)((class_3218)this.field_11863), (class_2338)this.field_11867, (FabricPacket)new CableIdSyncPacket(this.field_11867, ((CableNetworkImpl)this.cableNetwork).getId()));
        }
    }
}

