/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.blockentity;

import com.mikitellurium.telluriumforge.blockentity.TickingBlockEntity;
import com.mikitellurium.telluriumforge.config.RangedConfigEntry;
import com.mikitellurium.turtlechargingstation.common.block.ThunderchargeDynamoBlock;
import com.mikitellurium.turtlechargingstation.common.blockentity.CopperCableBlockEntity;
import com.mikitellurium.turtlechargingstation.common.energy.NetworkNode;
import com.mikitellurium.turtlechargingstation.common.integration.computercraft.ThunderchargeDynamoPeripheral;
import com.mikitellurium.turtlechargingstation.registry.ModBlockEntities;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import team.reborn.energy.api.EnergyStorage;

public class ThunderchargeDynamoBlockEntity
extends class_2586
implements TickingBlockEntity {
    private int charge = 0;
    public static RangedConfigEntry<Long> TRANSFER_RATE;
    public static RangedConfigEntry<Integer> RECHARGE_AMOUNT;

    public ThunderchargeDynamoBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.THUNDERCHARGE_DYNAMO, blockPos, blockState);
    }

    public void serverTick(class_3218 world, class_2338 blockPos, class_2680 blockState) {
        if (this.charge > 0) {
            class_2338 belowPos = blockPos.method_10093(class_2350.field_11033);
            class_2586 blockEntity = world.method_8321(belowPos);
            if (blockEntity != null) {
                NetworkNode node;
                if (blockEntity instanceof NetworkNode && (node = (NetworkNode)blockEntity).hasNetwork()) {
                    node.getNetwork().getReceivers().forEach(receiver -> {
                        EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.SIDED.find((class_1937)world, belowPos, receiver.method_11010(), receiver, null);
                        if (energyStorage != null) {
                            try (Transaction transaction = Transaction.openOuter();){
                                long amountInserted = energyStorage.insert(((Long)TRANSFER_RATE.get()).longValue(), (TransactionContext)transaction);
                                if (amountInserted > 0L) {
                                    transaction.commit();
                                }
                            }
                        }
                    });
                    node.getNetwork().getNodeByType(CopperCableBlockEntity.class).forEach(CopperCableBlockEntity::setBurning);
                } else {
                    EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.SIDED.find((class_1937)world, belowPos, blockEntity.method_11010(), blockEntity, (Object)class_2350.field_11036);
                    if (energyStorage != null) {
                        try (Transaction transaction = Transaction.openOuter();){
                            long amountInserted = energyStorage.insert(((Long)TRANSFER_RATE.get()).longValue(), (TransactionContext)transaction);
                            if (amountInserted > 0L) {
                                transaction.commit();
                            }
                        }
                    }
                }
            }
            --this.charge;
        }
        world.method_8501(blockPos, (class_2680)blockState.method_11657((class_2769)ThunderchargeDynamoBlock.POWERED, (Comparable)Boolean.valueOf(this.charge > 0)));
        ThunderchargeDynamoBlockEntity.method_31663((class_1937)world, (class_2338)blockPos, (class_2680)blockState);
    }

    public int getCharge() {
        return this.charge;
    }

    public void recharge() {
        this.charge = Math.min(this.getCharge() + (Integer)RECHARGE_AMOUNT.get(), Integer.MAX_VALUE);
    }

    public EnergyStorage energyLookup(class_2350 side) {
        return side == class_2350.field_11033 ? EnergyStorage.EMPTY : null;
    }

    public IPeripheral peripheralLookup(class_2350 side) {
        return new ThunderchargeDynamoPeripheral(this);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.charge = nbt.method_10550("charge");
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10569("charge", this.charge);
        super.method_11007(nbt);
    }
}

