/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.energy;

import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public abstract class ModEnergyStorage
extends SimpleEnergyStorage {
    public ModEnergyStorage(long capacity, long maxInsert) {
        this(capacity, maxInsert, maxInsert);
    }

    public ModEnergyStorage(long capacity, long maxInsert, long maxExtract) {
        super(capacity, maxInsert, maxExtract);
    }

    protected abstract void onFinalCommit();

    public long insert(long amount, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long amountInserted = super.insert(amount, (TransactionContext)transaction);
            if (amountInserted > 0L) {
                if (!simulate) {
                    transaction.commit();
                }
                long l = amountInserted;
                return l;
            }
        }
        return 0L;
    }

    public long extract(long amount, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long amountExtracted = super.extract(amount, (TransactionContext)transaction);
            if (amountExtracted > 0L) {
                if (!simulate) {
                    transaction.commit();
                }
                long l = amountExtracted;
                return l;
            }
        }
        return 0L;
    }

    public void setAmount(long energy) {
        this.amount = Math.max(0L, Math.min(energy, this.getCapacity()));
    }

    public class_2520 writeNbt() {
        return class_2503.method_23251((long)this.getAmount());
    }

    public void readNBT(class_2520 nbt) {
        if (!(nbt instanceof class_2503)) {
            throw new IllegalArgumentException("Cannot read an Nbt that isn't a long value");
        }
        class_2503 nbtLong = (class_2503)nbt;
        this.setAmount(nbtLong.method_10699());
    }
}

