/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.event;

import com.mikitellurium.telluriumforge.event.EventHelper;
import com.mikitellurium.turtlechargingstation.common.blockentity.ThunderchargeDynamoBlockEntity;
import com.mikitellurium.turtlechargingstation.mixin.CreeperEntityAccessor;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1538;
import net.minecraft.class_1548;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class GameplayEvents {
    private static final EventHelper HELPER = new EventHelper();

    public static void register() {
        HELPER.addListener(ServerEntityEvents.ENTITY_LOAD, GameplayEvents::onLightningStrike).registerAll();
    }

    private static void onLightningStrike(class_1297 entity, class_3218 world) {
        if (entity instanceof class_1538) {
            class_1538 lightningBolt = (class_1538)entity;
            class_2586 blockEntity = GameplayEvents.getBlockEntityBelow((class_1937)world, lightningBolt.method_23312());
            if (blockEntity == null) {
                return;
            }
            if (blockEntity instanceof ThunderchargeDynamoBlockEntity) {
                ThunderchargeDynamoBlockEntity dynamo = (ThunderchargeDynamoBlockEntity)blockEntity;
                dynamo.recharge();
                if (lightningBolt.method_35052() == null) {
                    GameplayEvents.maybeDoSpawnCreeper((class_3218)lightningBolt.method_37908(), dynamo.method_11016());
                }
            }
        }
    }

    private static class_2586 getBlockEntityBelow(class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        return blockEntity != null ? blockEntity : world.method_8321(pos.method_10074());
    }

    private static void maybeDoSpawnCreeper(class_3218 world, class_2338 pos) {
        if (world.field_9229.method_43048(1023) == 0) {
            Optional<class_2338> blockPos = GameplayEvents.getPossibleSpawnPos((class_1937)world, pos);
            blockPos.ifPresent(p -> {
                class_1548 creeper = (class_1548)class_1299.field_6046.method_47821(world, p, class_3730.field_16467);
                if (creeper != null) {
                    class_2940<Boolean> creeperIsCharged = CreeperEntityAccessor.getCHARGED();
                    creeper.method_5841().method_12778(creeperIsCharged, (Object)true);
                }
            });
        }
    }

    private static Optional<class_2338> getPossibleSpawnPos(class_1937 world, class_2338 blockPos) {
        class_2338 startPos = blockPos.method_10069(1, 2, 1);
        class_2338 downPos = blockPos.method_10069(-1, -10, -1);
        List<class_2338> list = class_2338.method_20437((class_2338)startPos, (class_2338)downPos).filter(pos -> world.method_8311(pos) && class_1948.method_8660((class_1317.class_1319)class_1317.class_1319.field_6317, (class_4538)world, (class_2338)pos, (class_1299)class_1299.field_6046)).map(class_2338::method_10062).toList();
        return class_156.method_40083(list, (class_5819)world.field_9229);
    }
}

