/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.client.gui.element;

import com.mikitellurium.telluriumforge.gui.TextureSprite;
import com.mikitellurium.turtlechargingstation.common.blockentity.TurtleChargingStationTileEntity;
import com.mikitellurium.turtlechargingstation.util.FastLoc;
import java.awt.Rectangle;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class EnergyStorageElement {
    private static final ResourceLocation ENERGY_STORAGE_TEXTURE = FastLoc.ofMod("textures/gui/energy_storage.png");
    private final TurtleChargingStationTileEntity tile;
    private final int textureWidth = 30;
    private final int textureHeight = 66;
    private final TextureSprite emptyStorage;
    private final TextureSprite fullStorage;
    private final int xPos;
    private final int yPos;

    public EnergyStorageElement(TurtleChargingStationTileEntity tile, int xPos, int yPos) {
        this.tile = tile;
        this.emptyStorage = new TextureSprite(ENERGY_STORAGE_TEXTURE, 0, 0, 16, 66, xPos, yPos);
        this.fullStorage = new TextureSprite(ENERGY_STORAGE_TEXTURE, 16, 0, 14, 64, xPos + 1, yPos + 1);
        this.xPos = xPos;
        this.yPos = yPos;
    }

    public void draw(GuiScreen parent) {
        parent.field_146297_k.func_110434_K().func_110577_a(this.emptyStorage.texture());
        Gui.func_146110_a((int)this.xPos, (int)this.yPos, (float)this.emptyStorage.uOffset(), (float)this.emptyStorage.vOffset(), (int)this.emptyStorage.width(), (int)this.emptyStorage.height(), (float)30.0f, (float)66.0f);
        if (this.tile.getEnergy() > 0) {
            this.drawEnergyLevel(parent);
        }
    }

    private void drawEnergyLevel(GuiScreen parent) {
        parent.field_146297_k.func_110434_K().func_110577_a(this.fullStorage.texture());
        Gui.func_146110_a((int)this.fullStorage.xPos(), (int)(this.fullStorage.yPos() + this.getEnergyLevel()), (float)this.fullStorage.uOffset(), (float)this.getEnergyLevel(), (int)this.fullStorage.width(), (int)(this.fullStorage.height() - this.getEnergyLevel()), (float)30.0f, (float)66.0f);
    }

    private int getEnergyLevel() {
        return this.fullStorage.height() - (int)Math.ceil((float)this.fullStorage.height() * ((float)this.tile.getEnergy() / (float)this.tile.getMaxEnergy()));
    }

    public ITextComponent getTooltip() {
        return new TextComponentString(this.tile.getEnergy() + "/" + this.tile.getMaxEnergy() + " FE");
    }

    public Rectangle getArea() {
        return new Rectangle(this.xPos, this.yPos, this.emptyStorage.width(), this.emptyStorage.height());
    }
}

