/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.block;

import com.mikitellurium.telluriumforge.util.ContainerUtils;
import com.mikitellurium.turtlechargingstation.client.ModGuiHandler;
import com.mikitellurium.turtlechargingstation.common.blockentity.TurtleChargingStationTileEntity;
import com.mikitellurium.turtlechargingstation.networking.ModNetworking;
import com.mikitellurium.turtlechargingstation.networking.packet.EnergySyncS2CPacket;
import com.mikitellurium.turtlechargingstation.registry.ModCreativeTabs;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;

public class TurtleChargingStationBlock
extends BlockContainer {
    public static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");
    public static final PropertyBool CHARGING = PropertyBool.func_177716_a((String)"charging");

    public TurtleChargingStationBlock() {
        super(Material.field_151576_e, MapColor.field_151646_E);
        this.func_149647_a(ModCreativeTabs.MAIN_TAB);
        this.func_149711_c(3.0f).func_149752_b(6.0f).setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)CHARGING, (Comparable)Boolean.valueOf(false)));
    }

    public SoundType func_185467_w() {
        return SoundType.field_185852_e;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TurtleChargingStationTileEntity();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ENABLED, CHARGING});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public IBlockState func_176203_a(int meta) {
        boolean enabled = (meta & 1) != 0;
        boolean charging = (meta & 2) != 0;
        return this.func_176223_P().func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(enabled)).func_177226_a((IProperty)CHARGING, (Comparable)Boolean.valueOf(charging));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            meta |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)CHARGING)).booleanValue()) {
            meta |= 2;
        }
        return meta;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TurtleChargingStationTileEntity) {
                TurtleChargingStationTileEntity stationTile = (TurtleChargingStationTileEntity)tile;
                ModGuiHandler.openTurtleChargingStationGui(playerIn, stationTile);
                ModNetworking.INSTANCE.sendToAll((IMessage)new EnergySyncS2CPacket(pos, stationTile.getEnergy()));
            } else {
                throw new IllegalStateException("Container provider is missing");
            }
        }
        return true;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.checkPoweredState(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkPoweredState(world, pos, state);
    }

    private void checkPoweredState(World world, BlockPos pos, IBlockState state) {
        boolean flag;
        boolean bl = flag = !world.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((IProperty)ENABLED)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile;
        if (stack.func_82837_s() && (tile = world.func_175625_s(pos)) instanceof TurtleChargingStationTileEntity) {
            ((TurtleChargingStationTileEntity)tile).setCustomName(stack.func_82833_r());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TurtleChargingStationTileEntity) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)ContainerUtils.fromItemHandler((IItemHandler)((TurtleChargingStationTileEntity)tile).getItemHandler()));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }
}

