/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlechargingstation.common.blockentity;

import com.mikitellurium.telluriumforge.energy.SimpleEnergyStorage;
import com.mikitellurium.telluriumforge.tileentity.ISideTickingTile;
import com.mikitellurium.turtlechargingstation.client.gui.TurtleChargingStationContainer;
import com.mikitellurium.turtlechargingstation.common.block.TurtleChargingStationBlock;
import com.mikitellurium.turtlechargingstation.networking.ModNetworking;
import com.mikitellurium.turtlechargingstation.networking.packet.EnergySyncS2CPacket;
import com.mikitellurium.turtlechargingstation.networking.packet.TurtleFuelSyncS2CPacket;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@Config(modid="turtlechargingstation")
public class TurtleChargingStationTileEntity
extends TileEntity
implements ISideTickingTile,
IInteractionObject {
    @Config.Name(value="chargingStationMaxCapacity")
    @Config.Comment(value={"The maximum amount of FE the charging station can hold."})
    @Config.RangeInt(min=0)
    public static int CAPACITY = 64000;
    @Config.Name(value="chargingStationConversionRate")
    @Config.Comment(value={"The amount of FE required to increase the turtle fuel level by 1."})
    @Config.RangeInt(min=0)
    public static int CONVERSION_RATE = 256;
    private String customName;
    private final int maxReceive = CONVERSION_RATE * 6;
    private final ItemStackHandler itemHandler = new ItemStackHandler(){

        protected void onContentsChanged(int slot) {
            TurtleChargingStationTileEntity.this.func_70296_d();
        }
    };
    private final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(CAPACITY, this.maxReceive){

        public void onEnergyChanged() {
            TurtleChargingStationTileEntity.this.func_70296_d();
            ModNetworking.INSTANCE.sendToAll((IMessage)new EnergySyncS2CPacket(TurtleChargingStationTileEntity.this.field_174879_c, this.energy));
        }
    };
    private final CCAccess access = new CCAccess(){

        @Override
        public BlockPos getPos() {
            return TurtleChargingStationTileEntity.this.field_174879_c;
        }

        @Override
        public IBlockState getBlockState() {
            return TurtleChargingStationTileEntity.this.field_145850_b.func_180495_p(TurtleChargingStationTileEntity.this.field_174879_c);
        }

        @Override
        public World getWorld() {
            return TurtleChargingStationTileEntity.this.field_145850_b;
        }
    };
    private final int textureChangeDelay = (int)Math.ceil((double)CONVERSION_RATE / 1024.0) + 1;
    private int textureTimer = 0;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return newState.func_177230_c() != oldState.func_177230_c();
    }

    public void func_73660_a() {
        this.tickTile(this);
    }

    public void tickServer(WorldServer world, IBlockState state, BlockPos pos) {
        IEnergyStorage stackStorage;
        int extracted;
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        if (itemStack.hasCapability(CapabilityEnergy.ENERGY, null) && (extracted = (stackStorage = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(this.maxReceive, true)) > 0 && this.getEnergy() < this.getMaxEnergy()) {
            int energy = this.energyStorage.receiveEnergy(extracted, false);
            stackStorage.extractEnergy(energy, false);
        }
        ArrayList<TileTurtle> turtles = new ArrayList<TileTurtle>();
        for (EnumFacing direction : EnumFacing.values()) {
            TileEntity tile = world.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (tile == null || !(tile instanceof TileTurtle)) continue;
            turtles.add((TileTurtle)tile);
        }
        boolean shouldCharge = !turtles.isEmpty() && this.hasChargeableTurtle(turtles) && this.energyStorage.getEnergyStored() >= CONVERSION_RATE;
        world.func_180501_a(pos, state.func_177226_a((IProperty)TurtleChargingStationBlock.CHARGING, (Comparable)Boolean.valueOf(shouldCharge || this.textureTimer > 0)), 2);
        if (shouldCharge && ((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)TurtleChargingStationBlock.ENABLED)).booleanValue()) {
            for (TileTurtle turtle : turtles) {
                if (!this.isChargeable(turtle) || this.energyStorage.getEnergyStored() < CONVERSION_RATE) continue;
                this.refuelTurtle(turtle);
                this.textureTimer = this.textureChangeDelay;
            }
        }
        if (this.textureTimer > 0) {
            --this.textureTimer;
        }
    }

    private boolean hasChargeableTurtle(List<TileTurtle> turtles) {
        for (TileTurtle turtle : turtles) {
            if (!this.isChargeable(turtle)) continue;
            return true;
        }
        return false;
    }

    private boolean isChargeable(TileTurtle turtle) {
        return turtle.getAccess().getFuelLevel() < turtle.getAccess().getFuelLimit();
    }

    private void refuelTurtle(TileTurtle turtle) {
        if (this.energyStorage.extractEnergy(CONVERSION_RATE, false) == CONVERSION_RATE) {
            turtle.getAccess().addFuel(1);
            ModNetworking.INSTANCE.sendToAll((IMessage)new TurtleFuelSyncS2CPacket(turtle.func_174877_v(), turtle.getAccess().getFuelLevel()));
        }
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public void setEnergy(int energy) {
        this.energyStorage.setEnergy(energy);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public CCAccess getAccess() {
        return this.access;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new TurtleChargingStationContainer((IInventory)playerInventory, this);
    }

    public String func_174875_k() {
        return this.func_145838_q().getRegistryName().toString();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : this.func_145838_q().func_149732_F();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStorage.setEnergy(nbt.func_74762_e("turtle_charging_station.energy"));
        this.itemHandler.deserializeNBT(nbt.func_74775_l("turtle_charging_station.inventory"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("turtle_charging_station.energy", this.energyStorage.getEnergyStored());
        nbt.func_74782_a("turtle_charging_station.inventory", (NBTBase)this.itemHandler.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public static interface CCAccess {
        public BlockPos getPos();

        public IBlockState getBlockState();

        public World getWorld();
    }
}

