/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.listeners.bossbar;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.world.BossEvent;
import net.minecraft.world.level.Level;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.event.task.GenerationTaskUpdateEvent;
import org.popcraft.chunky.platform.NeoForgeWorld;
import org.popcraft.chunky.platform.World;

public class BossBarTaskUpdateListener
implements Consumer<GenerationTaskUpdateEvent> {
    private final Map<Identifier, ServerBossEvent> bossBars;

    public BossBarTaskUpdateListener(Map<Identifier, ServerBossEvent> bossBars) {
        this.bossBars = bossBars;
    }

    @Override
    public void accept(GenerationTaskUpdateEvent event) {
        GenerationTask task = event.generationTask();
        Chunky chunky = task.getChunky();
        World world = task.getSelection().world();
        Identifier worldIdentifier = Identifier.tryParse((String)world.getKey());
        if (worldIdentifier == null || !(world instanceof NeoForgeWorld)) {
            return;
        }
        NeoForgeWorld neoForgeWorld = (NeoForgeWorld)world;
        ServerBossEvent bossBar = this.bossBars.computeIfAbsent(worldIdentifier, x -> this.createNewBossBar(worldIdentifier));
        boolean silent = chunky.getConfig().isSilent();
        if (silent == bossBar.isVisible()) {
            bossBar.setVisible(!silent);
        }
        MinecraftServer server = neoForgeWorld.getWorld().getServer();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            if (player.permissions().hasPermission(Permissions.COMMANDS_GAMEMASTER)) {
                bossBar.addPlayer(player);
                continue;
            }
            bossBar.removePlayer(player);
        }
        GenerationTask.Progress progress = task.getProgress();
        bossBar.setName(Component.nullToEmpty((String)String.format("%s | %s%% | %s:%s:%s", worldIdentifier, String.format("%.2f", Float.valueOf(progress.getPercentComplete())), String.format("%01d", progress.getHours()), String.format("%02d", progress.getMinutes()), String.format("%02d", progress.getSeconds()))));
        bossBar.setProgress(task.getProgress().getPercentComplete() / 100.0f);
        if (progress.isComplete()) {
            bossBar.removeAllPlayers();
            this.bossBars.remove(worldIdentifier);
        }
    }

    private ServerBossEvent createNewBossBar(Identifier worldIdentifier) {
        ServerBossEvent bossBar = new ServerBossEvent(Component.nullToEmpty((String)worldIdentifier.toString()), BossBarTaskUpdateListener.bossBarColor(worldIdentifier), BossEvent.BossBarOverlay.PROGRESS);
        bossBar.setDarkenScreen(false);
        bossBar.setPlayBossMusic(false);
        bossBar.setCreateWorldFog(false);
        return bossBar;
    }

    private static BossEvent.BossBarColor bossBarColor(Identifier worldIdentifier) {
        BossEvent.BossBarColor bossBarColor = Level.OVERWORLD.identifier().equals((Object)worldIdentifier) ? BossEvent.BossBarColor.GREEN : (Level.NETHER.identifier().equals((Object)worldIdentifier) ? BossEvent.BossBarColor.RED : (Level.END.identifier().equals((Object)worldIdentifier) ? BossEvent.BossBarColor.PURPLE : BossEvent.BossBarColor.BLUE));
        return bossBarColor;
    }
}

