/*
 * Decompiled with CFR 0.152.
 */
package net.romit.simpleedits.item.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.romit.simpleedits.item.custom.WandItem;
import net.romit.simpleedits.util.commands.RadiusCommand;
import net.romit.simpleedits.util.commands.ShapeCommand;

public class ShapeItem
extends class_1792 {
    private static final Map<UUID, Map<class_2338, class_2680>> playerUndoData = new HashMap<UUID, Map<class_2338, class_2680>>();

    public ShapeItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static void setBlockType(UUID playerId, String blockType) {
        WandItem.playerBlockTypes.put(playerId, blockType);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_1799 stack = context.method_8041();
        if (!world.field_9236 && player != null) {
            UUID playerId = player.method_5667();
            String blockType = WandItem.playerBlockTypes.getOrDefault(playerId, "minecraft:air");
            int radius = RadiusCommand.getRadius(player.method_5667());
            String shape = ShapeCommand.getShape(player.method_5667());
            this.storeOriginalBlocks(player, pos, radius, shape);
            boolean originalFeedback = world.method_8450().method_8355(class_1928.field_19400);
            ((class_1928.class_4310)world.method_8450().method_20746(class_1928.field_19400)).method_20758(false, world.method_8503());
            switch (shape) {
                case "square": {
                    this.createSquare(world, pos, blockType, radius);
                    break;
                }
                case "cube": {
                    this.createCube(world, pos, blockType, radius);
                    break;
                }
                case "sphere": {
                    this.createSphere(world, pos, blockType, radius);
                    break;
                }
                case "triangle": {
                    this.createTriangle(world, pos, blockType, radius);
                    break;
                }
                case "hexagon": {
                    this.createHexagon(world, pos, blockType, radius);
                    break;
                }
                default: {
                    this.createCircle(world, pos, blockType, radius);
                }
            }
            ((class_1928.class_4310)world.method_8450().method_20746(class_1928.field_19400)).method_20758(originalFeedback, world.method_8503());
            world.method_8396(player, pos, class_3417.field_14574, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void createSphere(class_1937 world, class_2338 pos, String blockType, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + y * y + z * z > radius * radius) continue;
                    world.method_8503().method_3734().method_44252(world.method_8503().method_3739(), String.format("/setblock %d %d %d %s", pos.method_10263() + x, pos.method_10264() + y, pos.method_10260() + z, blockType));
                }
            }
        }
    }

    private void createCube(class_1937 world, class_2338 pos, String blockType, int radius) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    world.method_8503().method_3734().method_44252(world.method_8503().method_3739(), String.format("/setblock %d %d %d %s", x + i, y + j, z + k, blockType));
                }
            }
        }
    }

    private void createSquare(class_1937 world, class_2338 pos, String blockType, int radius) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                world.method_8503().method_3734().method_44252(world.method_8503().method_3739(), String.format("/setblock %d %d %d %s", x + i, y, z + j, blockType));
            }
        }
    }

    private void createCircle(class_1937 world, class_2338 center, String blockType, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                class_2338 pos = center.method_10069(x, 0, z);
                world.method_8503().method_3734().method_44252(world.method_8503().method_3739(), String.format("/setblock %d %d %d %s", pos.method_10263(), pos.method_10264(), pos.method_10260(), blockType));
            }
        }
    }

    private void createTriangle(class_1937 world, class_2338 center, String blockType, int radius) {
        for (int y = 0; y <= radius; ++y) {
            for (int x = -y; x <= y; ++x) {
                int z = radius - y;
                class_2338 pos = center.method_10069(x, 0, z);
                world.method_8503().method_3734().method_44252(world.method_8503().method_3739(), String.format("/setblock %d %d %d %s", pos.method_10263(), pos.method_10264(), pos.method_10260(), blockType));
            }
        }
    }

    private void createHexagon(class_1937 world, class_2338 center, String blockType, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (Math.abs(x) + Math.abs(z) + Math.abs(x + z) > radius * 2) continue;
                class_2338 pos = center.method_10069(x, 0, z);
                world.method_8503().method_3734().method_44252(world.method_8503().method_3739(), String.format("/setblock %d %d %d %s", pos.method_10263(), pos.method_10264(), pos.method_10260(), blockType));
            }
        }
    }

    private void storeOriginalBlocks(class_1657 player, class_2338 center, int radius, String shape) {
        UUID playerId = player.method_5667();
        HashMap<class_2338, class_2680> originalBlocks = new HashMap<class_2338, class_2680>();
        switch (shape) {
            case "square": {
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        class_2338 pos = center.method_10069(x, 0, z);
                        originalBlocks.put(pos, player.method_37908().method_8320(pos));
                    }
                }
                break;
            }
            case "cube": {
                for (int x = -radius; x <= radius; ++x) {
                    for (int y = -radius; y <= radius; ++y) {
                        for (int z = -radius; z <= radius; ++z) {
                            class_2338 pos = center.method_10069(x, y, z);
                            originalBlocks.put(pos, player.method_37908().method_8320(pos));
                        }
                    }
                }
                break;
            }
            case "sphere": {
                for (int x = -radius; x <= radius; ++x) {
                    for (int y = -radius; y <= radius; ++y) {
                        for (int z = -radius; z <= radius; ++z) {
                            if (x * x + y * y + z * z > radius * radius) continue;
                            class_2338 pos = center.method_10069(x, y, z);
                            originalBlocks.put(pos, player.method_37908().method_8320(pos));
                        }
                    }
                }
                break;
            }
            case "triangle": {
                for (int y = 0; y <= radius; ++y) {
                    for (int x = -y; x <= y; ++x) {
                        int z = radius - y;
                        class_2338 pos = center.method_10069(x, 0, z);
                        originalBlocks.put(pos, player.method_37908().method_8320(pos));
                    }
                }
                break;
            }
            case "hexagon": {
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (Math.abs(x) + Math.abs(z) + Math.abs(x + z) > radius * 2) continue;
                        class_2338 pos = center.method_10069(x, 0, z);
                        originalBlocks.put(pos, player.method_37908().method_8320(pos));
                    }
                }
                break;
            }
            default: {
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (x * x + z * z > radius * radius) continue;
                        class_2338 pos = center.method_10069(x, 0, z);
                        originalBlocks.put(pos, player.method_37908().method_8320(pos));
                    }
                }
            }
        }
        playerUndoData.put(playerId, originalBlocks);
    }

    public static void undoShapeCommand(class_1657 player) {
        UUID playerId = player.method_5667();
        Map<class_2338, class_2680> originalBlocks = playerUndoData.get(playerId);
        if (originalBlocks != null) {
            for (Map.Entry<class_2338, class_2680> entry : originalBlocks.entrySet()) {
                player.method_37908().method_8501(entry.getKey(), entry.getValue());
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"Undo operation completed."), false);
            playerUndoData.remove(playerId);
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)"No undo data available."), false);
        }
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.simpleedits.shapewand.tooltip"));
        super.method_7851(stack, context, tooltip, type);
    }
}

