/*
 * Decompiled with CFR 0.152.
 */
package net.romit.simpleedits.item.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;

public class WandItem
extends class_1792 {
    public static final Map<UUID, class_2338[]> playerPositions = new HashMap<UUID, class_2338[]>();
    public static final Map<UUID, String> playerBlockTypes = new HashMap<UUID, String>();
    public static final Map<UUID, Map<class_2338, class_2680>> playerUndoData = new HashMap<UUID, Map<class_2338, class_2680>>();

    public WandItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static void setBlockType(UUID playerId, String blockType) {
        playerBlockTypes.put(playerId, blockType);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player != null && !context.method_8045().field_9236) {
            UUID playerId = player.method_5667();
            class_2338 pos = context.method_8037();
            class_2338[] positions = playerPositions.getOrDefault(playerId, new class_2338[2]);
            class_1937 world = context.method_8045();
            if (positions[0] == null) {
                positions[0] = pos;
                player.method_7353((class_2561)class_2561.method_43470((String)("First position set at: " + String.valueOf(pos))), false);
                world.method_8396(null, pos, class_3417.field_14727, class_3419.field_15245, 1.0f, 1.0f);
            } else {
                positions[1] = pos;
                player.method_7353((class_2561)class_2561.method_43470((String)("Second position set at: " + String.valueOf(pos))), false);
                world.method_8396(null, pos, class_3417.field_14727, class_3419.field_15245, 1.0f, 1.0f);
                String blockType = playerBlockTypes.getOrDefault(playerId, "minecraft:air");
                this.storeOriginalBlocks(player, positions[0], positions[1]);
                this.executeFillCommand(player, positions[0], positions[1], blockType);
                positions[0] = null;
                positions[1] = null;
            }
            playerPositions.put(playerId, positions);
        }
        return class_1269.field_5812;
    }

    private void storeOriginalBlocks(class_1657 player, class_2338 pos1, class_2338 pos2) {
        UUID playerId = player.method_5667();
        HashMap<class_2338, class_2680> originalBlocks = new HashMap<class_2338, class_2680>();
        int x1 = pos1.method_10263();
        int y1 = pos1.method_10264();
        int z1 = pos1.method_10260();
        int x2 = pos2.method_10263();
        int y2 = pos2.method_10264();
        int z2 = pos2.method_10260();
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        int maxZ = Math.max(z1, z2);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    originalBlocks.put(pos, player.method_37908().method_8320(pos));
                }
            }
        }
        playerUndoData.put(playerId, originalBlocks);
    }

    public static void clearPositions(UUID playerId) {
        playerPositions.remove(playerId);
    }

    private void executeFillCommand(class_1657 player, class_2338 pos1, class_2338 pos2, String blockType) {
        class_2168 source = player.method_5671();
        boolean originalFeedback = source.method_9225().method_8450().method_8355(class_1928.field_19400);
        ((class_1928.class_4310)source.method_9225().method_8450().method_20746(class_1928.field_19400)).method_20758(false, source.method_9211());
        int maxVolume = 32768;
        int x1 = pos1.method_10263();
        int y1 = pos1.method_10264();
        int z1 = pos1.method_10260();
        int x2 = pos2.method_10263();
        int y2 = pos2.method_10264();
        int z2 = pos2.method_10260();
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        int maxZ = Math.max(z1, z2);
        for (int x = minX; x <= maxX; x += 32) {
            for (int y = minY; y <= maxY; y += 32) {
                for (int z = minZ; z <= maxZ; z += 32) {
                    int endY = Math.min(y + 31, maxY);
                    int endZ = Math.min(z + 31, maxZ);
                    int endX = Math.min(x + 31, maxX);
                    int volume = (endX - x + 1) * (endY - y + 1) * (endZ - z + 1);
                    if (volume <= maxVolume) {
                        String command = String.format("/fill %d %d %d %d %d %d %s", x, y, z, endX, endY, endZ, blockType);
                        source.method_9211().method_3734().method_44252(source, command);
                        continue;
                    }
                    for (int subX = x; subX <= endX; subX += 16) {
                        for (int subY = y; subY <= endY; subY += 16) {
                            for (int subZ = z; subZ <= endZ; subZ += 16) {
                                int subEndX = Math.min(subX + 15, endX);
                                int subEndY = Math.min(subY + 15, endY);
                                int subEndZ = Math.min(subZ + 15, endZ);
                                String subCommand = String.format("/fill %d %d %d %d %d %d %s", subX, subY, subZ, subEndX, subEndY, subEndZ, blockType);
                                source.method_9211().method_3734().method_44252(source, subCommand);
                            }
                        }
                    }
                }
            }
        }
        ((class_1928.class_4310)source.method_9225().method_8450().method_20746(class_1928.field_19400)).method_20758(originalFeedback, source.method_9211());
    }

    public static void undoFillCommand(class_3222 player) {
        UUID playerId = player.method_5667();
        Map<class_2338, class_2680> originalBlocks = playerUndoData.get(playerId);
        if (originalBlocks != null) {
            for (Map.Entry<class_2338, class_2680> entry : originalBlocks.entrySet()) {
                player.method_37908().method_8501(entry.getKey(), entry.getValue());
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"Undo operation completed."), false);
            playerUndoData.remove(playerId);
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)"No undo data available."), false);
        }
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.simpleedits.wand.shift_down"));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.simpleedits.wand"));
        }
        super.method_7851(stack, context, tooltip, type);
    }
}

