/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.api;

import de.pianoman911.mapengine.api.clientside.IDisplayProvider;
import de.pianoman911.mapengine.api.clientside.IHoldableDisplay;
import de.pianoman911.mapengine.api.clientside.IMapDisplay;
import de.pianoman911.mapengine.api.colors.IMapColors;
import de.pianoman911.mapengine.api.pipeline.IPipelineProvider;
import de.pianoman911.mapengine.api.util.MapTraceResult;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface MapEngineApi {
    @NotNull
    public static MapEngineApi instance() {
        MapEngineApi instance = (MapEngineApi)Bukkit.getServicesManager().load(MapEngineApi.class);
        if (instance == null) {
            throw new IllegalStateException("MapEngine is not enabled! Please check if the plugin is properly enabled. Maybe you are using the API before MapEngine is enabled?");
        }
        return instance;
    }

    public IMapColors colors();

    public IPipelineProvider pipeline();

    public IDisplayProvider displayProvider();

    public @Unmodifiable Set<IMapDisplay> mapDisplays();

    public @Unmodifiable Set<IHoldableDisplay> holdableDisplays();

    @Deprecated
    @Nullable
    public IMapDisplay displayInView(Player var1, int var2);

    @Nullable
    public MapTraceResult traceDisplayInView(Player var1);

    @Nullable
    public MapTraceResult traceDisplayInView(Player var1, int var2);
}

