/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.api.util;

import de.pianoman911.mapengine.api.util.FullSpacedColorBuffer;
import de.pianoman911.mapengine.api.util.ImageUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.util.NumberConversions;

public final class FontRegistry {
    public static final Font DEFAULT = new Font("Arial", 0, 10);
    private static final Rectangle2D ZERO_RECT = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    public static final FullSpacedColorBuffer EMPTY_BUFFER = new FullSpacedColorBuffer(0, 0);

    private FontRegistry() {
    }

    public static BufferedImage convertText(String text, Font font, Color color) {
        return FontRegistry.convertText(text, font, color, true);
    }

    public static BufferedImage convertText(String text, Font font, Color color, boolean antiAliasing) {
        return FontRegistry.convertTextBuffer(text, font, color, antiAliasing).snapshot();
    }

    private static FullSpacedColorBuffer convertTextBuffer(String text, Font font, Color color, boolean antiAliasing) {
        BufferedImage img;
        if (font == null) {
            font = DEFAULT;
        }
        if ((img = FontRegistry.renderMultiLineText(text, font, color, antiAliasing)) == null) {
            return EMPTY_BUFFER;
        }
        return new FullSpacedColorBuffer(ImageUtils.rgb(img), img.getWidth(), img.getHeight()).cropAlpha();
    }

    private static BufferedImage renderMultiLineText(String text, Font font, Color color, boolean antiAliasing) {
        String[] lines = StringUtils.splitPreserveAllTokens((String)text, (char)'\n');
        if (lines.length < 1) {
            return null;
        }
        FontRenderContext ctx = new FontRenderContext(null, antiAliasing, false);
        LineData[] data = new LineData[lines.length];
        Rectangle2D totalRect = (Rectangle2D)ZERO_RECT.clone();
        for (int i = 0; i < lines.length; ++i) {
            GlyphVector vec = font.createGlyphVector(ctx, lines[i]);
            Rectangle2D bounds = vec.getLogicalBounds();
            totalRect.setRect(0.0, 0.0, Math.max(totalRect.getWidth(), bounds.getWidth()), totalRect.getHeight() + bounds.getHeight());
            data[i] = new LineData(vec, bounds);
        }
        if (totalRect.getWidth() == 0.0 || totalRect.getHeight() == 0.0) {
            return null;
        }
        BufferedImage img = new BufferedImage(NumberConversions.ceil((double)totalRect.getWidth()), NumberConversions.ceil((double)totalRect.getHeight()), 2);
        Graphics2D graphics = img.createGraphics();
        graphics.setColor(color);
        for (LineData datum : data) {
            graphics.drawGlyphVector(datum.vec(), 0.0f, (float)(-datum.bounds().getY()));
            graphics.translate(0.0, datum.bounds().getHeight());
        }
        return img;
    }

    public static FullSpacedColorBuffer convertText2Bytes(String text, Font font, Color color) {
        return FontRegistry.convertText2Bytes(text, font, color, true);
    }

    public static FullSpacedColorBuffer convertText2Bytes(String text, Font font, Color color, boolean antiAliasing) {
        return FontRegistry.convertTextBuffer(text, font, color, antiAliasing);
    }

    private record LineData(GlyphVector vec, Rectangle2D bounds) {
    }
}

