/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.api.util;

import com.google.common.base.Preconditions;
import de.pianoman911.mapengine.api.util.Rotation;
import java.awt.image.BufferedImage;

public class FullSpacedColorBuffer {
    private final int[] data;
    private final int width;
    private final int height;

    public FullSpacedColorBuffer(int[] data, int width, int height) {
        Preconditions.checkState((data.length == 0 && width == 0 && height == 0 || data.length / width == height ? 1 : 0) != 0, (String)"Width %s and height %s invalid for rgb array with length %s", (Object)width, (Object)height, (Object)data.length);
        this.data = data;
        this.width = width;
        this.height = height;
    }

    @Deprecated
    public FullSpacedColorBuffer(int size, int width, int height) {
        this(width, height);
    }

    public FullSpacedColorBuffer(int width, int height) {
        this(new int[width * height], width, height);
    }

    private static final int index(int x, int y, int width) {
        return x + y * width;
    }

    private static float linearFloat2srgb(float val) {
        if (val >= 0.938f) {
            return val * 2.2f - 1.2f;
        }
        float adjustedVal = val - 0.015f;
        return adjustedVal * adjustedVal;
    }

    private static int srgb2linearByte(float srgb) {
        if (srgb >= 0.8636f) {
            return (int)((srgb + 1.2f) / 0.008627451f);
        }
        return (int)((Math.sqrt(srgb) + (double)0.015f) * 255.0);
    }

    public void pixel(int x, int y, int newColor) {
        int newAlpha = newColor >> 24 & 0xFF;
        if (newAlpha == 255) {
            this.data[x + y * this.width()] = newColor;
            return;
        }
        if (newAlpha == 0) {
            return;
        }
        float newRed = (float)(newColor >> 16 & 0xFF) / 255.0f;
        float newGreen = (float)(newColor >> 8 & 0xFF) / 255.0f;
        float newBlue = (float)(newColor & 0xFF) / 255.0f;
        int colorIndex = x + y * this.width();
        int oldColor = this.data[colorIndex];
        float oldAlpha = (float)(oldColor >> 24 & 0xFF) / 255.0f;
        float oldRed = (float)(oldColor >> 16 & 0xFF) / 255.0f;
        float oldGreen = (float)(oldColor >> 8 & 0xFF) / 255.0f;
        float oldBlue = (float)(oldColor & 0xFF) / 255.0f;
        float newAlphaF = (float)newAlpha / 255.0f;
        float alpha = newAlphaF + oldAlpha * (1.0f - newAlphaF);
        int red = FullSpacedColorBuffer.srgb2linearByte((FullSpacedColorBuffer.linearFloat2srgb(newRed) * newAlphaF + FullSpacedColorBuffer.linearFloat2srgb(oldRed) * oldAlpha * (1.0f - newAlphaF)) / alpha);
        int green = FullSpacedColorBuffer.srgb2linearByte((FullSpacedColorBuffer.linearFloat2srgb(newGreen) * newAlphaF + FullSpacedColorBuffer.linearFloat2srgb(oldGreen) * oldAlpha * (1.0f - newAlphaF)) / alpha);
        int blue = FullSpacedColorBuffer.srgb2linearByte((FullSpacedColorBuffer.linearFloat2srgb(newBlue) * newAlphaF + FullSpacedColorBuffer.linearFloat2srgb(oldBlue) * oldAlpha * (1.0f - newAlphaF)) / alpha);
        this.data[colorIndex] = (int)(alpha * 255.0f) << 24 | red << 16 | green << 8 | blue;
    }

    public final void pixels(int[] pixels, int x, int y, int width, int height) {
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                if (x + w < 0 || x + w >= this.width() || y + h < 0 || y + h >= this.height()) continue;
                this.pixel(x + w, y + h, pixels[FullSpacedColorBuffer.index(w, h, width)]);
            }
        }
    }

    public final void buffer(FullSpacedColorBuffer buffer, int x, int y) {
        this.pixels(buffer.buffer(), x, y, buffer.width(), buffer.height());
    }

    public final void replaceColor(int oldColor, int newColor) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != oldColor) continue;
            this.data[i] = newColor;
        }
    }

    public final void removeColor(int color) {
        this.replaceColor(color, 0);
    }

    public final FullSpacedColorBuffer scale(double scale, boolean smooth) {
        return this.scale(scale, scale, smooth);
    }

    public FullSpacedColorBuffer scale(double scaleX, double scaleY, boolean smooth) {
        int newWidth = (int)((double)this.width * scaleX);
        int newHeight = (int)((double)this.height * scaleY);
        int[] newData = new int[newWidth * newHeight];
        double ratioX = (double)this.width / (double)newWidth;
        double ratioY = (double)this.height / (double)newHeight;
        for (int y = 0; y < newHeight; ++y) {
            for (int x = 0; x < newWidth; ++x) {
                int scrX = (int)((double)x * ratioX);
                int scrY = (int)((double)y * ratioY);
                int scrIndex = scrX + scrY * this.width;
                if (scrX >= this.width || scrY >= this.height) continue;
                int color = this.data[scrIndex];
                if (smooth) {
                    int alpha = color >> 24 & 0xFF;
                    int red = color >> 16 & 0xFF;
                    int green = color >> 8 & 0xFF;
                    int blue = color & 0xFF;
                    int count = 1;
                    if (scrX + 1 < this.width) {
                        color = this.data[scrIndex + 1];
                        alpha += color >> 24 & 0xFF;
                        red += color >> 16 & 0xFF;
                        green += color >> 8 & 0xFF;
                        blue += color & 0xFF;
                        ++count;
                    }
                    if (scrY + 1 < this.height) {
                        color = this.data[scrIndex + this.width];
                        alpha += color >> 24 & 0xFF;
                        red += color >> 16 & 0xFF;
                        green += color >> 8 & 0xFF;
                        blue += color & 0xFF;
                        ++count;
                    }
                    if (scrX + 1 < this.width && scrY + 1 < this.height) {
                        color = this.data[scrIndex + this.width + 1];
                        alpha += color >> 24 & 0xFF;
                        red += color >> 16 & 0xFF;
                        green += color >> 8 & 0xFF;
                        blue += color & 0xFF;
                        ++count;
                    }
                    color = alpha / count << 24 | red / count << 16 | green / count << 8 | blue / count;
                }
                newData[FullSpacedColorBuffer.index((int)x, (int)y, (int)newWidth)] = color;
            }
        }
        return new FullSpacedColorBuffer(newData, newWidth, newHeight);
    }

    public FullSpacedColorBuffer rotate(Rotation rotation) {
        int newWidth = rotation == Rotation.CLOCKWISE || rotation == Rotation.COUNTER_CLOCKWISE ? this.height : this.width;
        int newHeight = rotation == Rotation.CLOCKWISE || rotation == Rotation.COUNTER_CLOCKWISE ? this.width : this.height;
        int[] newData = new int[newWidth * newHeight];
        for (int y = 0; y < newHeight; ++y) {
            for (int x = 0; x < newWidth; ++x) {
                int newX;
                newData[x + y * newWidth] = this.data[this.index(newX, switch (rotation) {
                    case Rotation.CLOCKWISE -> {
                        newX = y;
                        yield newHeight - x - 1;
                    }
                    case Rotation.COUNTER_CLOCKWISE -> {
                        newX = newWidth - y - 1;
                        yield x;
                    }
                    case Rotation.UPSIDE_DOWN -> {
                        newX = newWidth - x - 1;
                        yield newHeight - y - 1;
                    }
                    default -> {
                        newX = x;
                        yield y;
                    }
                })];
            }
        }
        return new FullSpacedColorBuffer(newData, newWidth, newHeight);
    }

    public FullSpacedColorBuffer applySuperSampling(int factor) {
        Preconditions.checkState((factor > 0 ? 1 : 0) != 0, (String)"Invalid super-sampling factor: %s", (int)factor);
        FullSpacedColorBuffer buffer = new FullSpacedColorBuffer(this.width + 2 * factor, this.height + 2 * factor);
        buffer.buffer(this, factor, factor);
        return buffer.scale(factor, true).scale(1.0 / (double)factor, true);
    }

    public final FullSpacedColorBuffer scale(int newWidth, int newHeight, boolean smooth) {
        return this.scale((double)newWidth / (double)this.width, (double)newHeight / (double)this.height, smooth);
    }

    public BufferedImage snapshot() {
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        image.setRGB(0, 0, this.width, this.height, this.data, 0, this.width);
        return image;
    }

    public final FullSpacedColorBuffer subBuffer(int x, int y, int width, int height) {
        int[] newData = new int[width * height];
        for (int h = 0; h < height; ++h) {
            System.arraycopy(this.data, this.index(x, y + h), newData, h * width, width);
        }
        return new FullSpacedColorBuffer(newData, width, height);
    }

    public final FullSpacedColorBuffer cropAlpha() {
        return this.crop(0);
    }

    public FullSpacedColorBuffer crop(int background) {
        int minY;
        int minX = 0;
        int maxX = this.width - 1;
        int maxY = this.height - 1;
        for (minY = 0; minY < maxY && !this.colorInLineY(background, minY); ++minY) {
        }
        while (maxY > minY && !this.colorInLineY(background, maxY)) {
            --maxY;
        }
        while (minX < maxX && !this.colorInLineX(background, minX, minY, maxY)) {
            ++minX;
        }
        while (maxX > minX && !this.colorInLineX(background, maxX, minY, maxY)) {
            --maxX;
        }
        return this.subBuffer(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }

    private final boolean colorInLineY(int background, int maxY) {
        int len = this.width - 1;
        for (int x = 0; x < len; ++x) {
            if (this.pixel(x, maxY) == background) continue;
            return true;
        }
        return false;
    }

    private final boolean colorInLineX(int background, int minX, int minY, int maxY) {
        for (int y = minY; y < maxY; ++y) {
            if (this.pixel(minX, y) == background) continue;
            return true;
        }
        return false;
    }

    public final FullSpacedColorBuffer copy() {
        return new FullSpacedColorBuffer((int[])this.data.clone(), this.width, this.height);
    }

    private final int index(int x, int y) {
        return FullSpacedColorBuffer.index(x, y, this.width);
    }

    public final int pixel(int x, int y) {
        return this.data[this.index(x, y)];
    }

    public final int[] buffer() {
        return this.data;
    }

    public final int size() {
        return this.data.length;
    }

    public final int width() {
        return this.width;
    }

    public final int height() {
        return this.height;
    }
}

