/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.api.util;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public final class ImageUtils {
    private ImageUtils() {
    }

    public static BufferedImage resize(BufferedImage image, int width, int height) {
        BufferedImage result = new BufferedImage(width, height, 2);
        Graphics2D graphics = result.createGraphics();
        graphics.drawImage(image, 0, 0, width, height, null);
        graphics.dispose();
        return result;
    }

    public static int[] rgb(BufferedImage image) {
        int[] rgb = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), rgb, 0, image.getWidth());
        return rgb;
    }

    public static BufferedImage cutImage(BufferedImage image) {
        int startX = image.getWidth();
        int startY = image.getHeight();
        int endX = 0;
        int endY = 0;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                if ((image.getRGB(x, y) >> 24 & 0xFF) == 0) continue;
                startX = Math.min(startX, x);
                startY = Math.min(startY, y);
                endX = Math.max(endX, x);
                endY = Math.max(endY, y);
            }
        }
        BufferedImage cutImage = new BufferedImage(++endX - startX, ++endY - startY, 2);
        Graphics2D gc = cutImage.createGraphics();
        gc.drawImage(image, 0, 0, endX - startX, endY - startY, startX, startY, endX, endY, null);
        gc.dispose();
        return cutImage;
    }
}

