/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.common;

import de.pianoman911.mapengine.common.Paper1202Listener;
import de.pianoman911.mapengine.common.data.MapUpdateData;
import de.pianoman911.mapengine.common.platform.IListenerBridge;
import de.pianoman911.mapengine.common.platform.IPlatform;
import de.pianoman911.mapengine.common.platform.PacketContainer;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.papermc.paper.adventure.PaperAdventure;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.SharedConstants;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class Paper1202Platform
implements IPlatform<Packet<PacketListenerPlayOut>>,
Listener {
    private static final Entity FAKED_ENTITY = new EntityEgg((World)MinecraftServer.getServer().D(), 0.0, 0.0, 0.0);
    private static final DataWatcherObject<Byte> DATA_SHARED_FLAGS_ID = DataWatcherRegistry.a.a(0);
    private static final DataWatcherObject<Float> DATA_INTERACTION_BOX_WIDTH_ID = DataWatcherRegistry.d.a(8);
    private static final DataWatcherObject<Float> DATA_INTERACTION_BOX_HEIGHT_ID = DataWatcherRegistry.d.a(9);
    private static final DataWatcherObject<Boolean> DATA_INTERACTION_BOX_RESPONSIVE_ID = DataWatcherRegistry.k.a(10);
    private final IListenerBridge bridge;

    public Paper1202Platform(Plugin plugin, IListenerBridge bridge) {
        this.bridge = bridge;
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Paper1202Listener listener = new Paper1202Listener(event.getPlayer(), this.bridge);
        ((CraftPlayer)event.getPlayer()).getHandle().c.c.n.pipeline().addAfter("decoder", "mapengine", (ChannelHandler)listener);
    }

    @Override
    public String getDisplayedName() {
        return MinecraftServer.getServer().getServerModName() + " " + SharedConstants.b().c();
    }

    @Override
    public void sendPacket(Player player, PacketContainer<Packet<PacketListenerPlayOut>> packet) {
        ((CraftPlayer)player).getHandle().c.c.n.write(packet.getPacket());
    }

    @Override
    public void flush(Player player) {
        ((CraftPlayer)player).getHandle().c.c.n.flush();
    }

    @Override
    public PacketContainer<Packet<PacketListenerPlayOut>> createMapDataPacket(MapUpdateData data, int mapId, MapCursorCollection cursors) {
        ArrayList<MapIcon> decorations;
        WorldMap.b updateData = new WorldMap.b((int)data.offsetX(), (int)data.offsetY(), data.width(), data.height(), data.buffer());
        if (cursors != null && cursors.size() > 0) {
            decorations = new ArrayList<MapIcon>(cursors.size());
            for (int i = 0; i < cursors.size(); ++i) {
                MapCursor cursor = cursors.getCursor(i);
                if (!cursor.isVisible()) continue;
                decorations.add(new MapIcon(MapIcon.Type.a((byte)cursor.getRawType()), cursor.getX(), cursor.getY(), cursor.getDirection(), PaperAdventure.asVanilla((Component)cursor.caption())));
            }
        } else {
            decorations = null;
        }
        return PacketContainer.wrap(this, new PacketPlayOutMap(mapId, 0, decorations != null, decorations, updateData));
    }

    @Override
    public PacketContainer<Packet<PacketListenerPlayOut>> createMapEntitySpawnPacket(int entityId, BlockVector pos, BlockFace facing, boolean glowing) {
        int facingIndex = switch (facing) {
            case BlockFace.UP -> 1;
            case BlockFace.NORTH -> 2;
            case BlockFace.SOUTH -> 3;
            case BlockFace.WEST -> 4;
            case BlockFace.EAST -> 5;
            default -> 0;
        };
        return PacketContainer.wrap(this, new PacketPlayOutSpawnEntity(entityId, UUID.randomUUID(), pos.getX(), pos.getY(), pos.getZ(), 0.0f, 0.0f, glowing ? EntityTypes.S : EntityTypes.af, facingIndex, Vec3D.b, 0.0));
    }

    @Override
    public PacketContainer<Packet<PacketListenerPlayOut>> createMapSetIdPacket(int entityId, int mapId, boolean invisible) {
        DataWatcher entityData = new DataWatcher(FAKED_ENTITY);
        ItemStack mapItem = Items.rf.ai_();
        mapItem.w().a("map", mapId);
        entityData.a(EntityItemFrame.g, (Object)ItemStack.b);
        entityData.b(EntityItemFrame.g, (Object)mapItem);
        if (invisible) {
            entityData.a(DATA_SHARED_FLAGS_ID, (Object)0);
            entityData.b(DATA_SHARED_FLAGS_ID, (Object)32);
        }
        return PacketContainer.wrap(this, new PacketPlayOutEntityMetadata(entityId, Objects.requireNonNull(entityData.b())));
    }

    @Override
    public PacketContainer<Packet<PacketListenerPlayOut>> createRemoveEntitiesPacket(IntList entityIds) {
        return PacketContainer.wrap(this, new PacketPlayOutEntityDestroy(entityIds));
    }

    @Override
    public PacketContainer<?> createInteractionEntitySpawnPacket(int interactionId, Vector pos, BlockFace direction) {
        return PacketContainer.wrap(this, new PacketPlayOutSpawnEntity(interactionId, UUID.randomUUID(), pos.getX(), pos.getY(), pos.getZ(), 0.0f, 0.0f, EntityTypes.ab, 0, Vec3D.b, 0.0));
    }

    @Override
    public PacketContainer<?> createInteractionEntityBlockSizePacket(int interactionId) {
        DataWatcher entityData = new DataWatcher(FAKED_ENTITY);
        entityData.a(DATA_INTERACTION_BOX_WIDTH_ID, (Object)Float.valueOf(0.0f));
        entityData.b(DATA_INTERACTION_BOX_WIDTH_ID, (Object)Float.valueOf(1.0f));
        entityData.a(DATA_INTERACTION_BOX_HEIGHT_ID, (Object)Float.valueOf(0.0f));
        entityData.b(DATA_INTERACTION_BOX_HEIGHT_ID, (Object)Float.valueOf(1.0f));
        entityData.a(DATA_INTERACTION_BOX_RESPONSIVE_ID, (Object)false);
        entityData.b(DATA_INTERACTION_BOX_RESPONSIVE_ID, (Object)true);
        entityData.a(DATA_SHARED_FLAGS_ID, (Object)0);
        entityData.b(DATA_SHARED_FLAGS_ID, (Object)32);
        return PacketContainer.wrap(this, new PacketPlayOutEntityMetadata(interactionId, Objects.requireNonNull(entityData.b())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketContainer<?> createTeleportPacket(int entityId, Vector pos, float yaw, float pitch, boolean onGround) {
        PacketPlayOutEntityTeleport packet;
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer((int)32));
        try {
            buf.c(entityId);
            buf.a(pos.getX());
            buf.a(pos.getY());
            buf.a(pos.getZ());
            buf.k((int)(yaw * 256.0f / 360.0f));
            buf.k((int)(pitch * 256.0f / 360.0f));
            buf.a(onGround);
            packet = new PacketPlayOutEntityTeleport(buf);
        }
        finally {
            buf.release();
        }
        return PacketContainer.wrap(this, packet);
    }

    @Override
    public PacketContainer<?> createItemRotationPacket(int entityId, int rotation) {
        DataWatcher entityData = new DataWatcher(FAKED_ENTITY);
        entityData.a(EntityItemFrame.h, (Object)0);
        entityData.b(EntityItemFrame.h, (Object)rotation);
        return PacketContainer.wrap(this, new PacketPlayOutEntityMetadata(entityId, Objects.requireNonNull(entityData.b())));
    }

    @Override
    public void sendBundled(Player player, PacketContainer<?> ... packets) {
        ArrayList<Packet> mcPackets = new ArrayList<Packet>(packets.length);
        for (PacketContainer<?> packetContainer : packets) {
            mcPackets.add((Packet)packetContainer.getPacket());
        }
        ClientboundBundlePacket packet = new ClientboundBundlePacket(mcPackets);
        ((CraftPlayer)player).getHandle().c.b((Packet)packet);
    }
}

