/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core.cache;

import com.google.common.base.Preconditions;
import de.pianoman911.mapengine.core.cache.FrameCache;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFrameCache
implements FrameCache {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"MapEngine[FrameFileCache]");
    private final File file;
    private final RandomAccessFile cache;
    private final WeakReference<byte[]>[] memoryCache;
    private volatile boolean closed = false;

    public FileFrameCache(File file, int size) {
        this.file = file;
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        file.deleteOnExit();
        try {
            this.cache = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException exception) {
            throw new RuntimeException(exception);
        }
        this.memoryCache = new WeakReference[size];
        Arrays.fill(this.memoryCache, new WeakReference<Object>(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(int index) {
        FileFrameCache fileFrameCache = this;
        synchronized (fileFrameCache) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cache is already closed");
            byte[] buffer = (byte[])this.memoryCache[index].get();
            if (buffer != null) {
                return buffer;
            }
            byte[] data = new byte[16384];
            try {
                FileChannel channel = this.cache.getChannel();
                channel.map(FileChannel.MapMode.READ_ONLY, 16384L * (long)index, 16384L).get(data);
            }
            catch (IOException exception) {
                throw new RuntimeException("Failed to read cache file: " + this.file.getName(), exception);
            }
            this.memoryCache[index] = new WeakReference<byte[]>(data);
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] data, int index) {
        FileFrameCache fileFrameCache = this;
        synchronized (fileFrameCache) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cache is already closed");
            this.memoryCache[index] = new WeakReference<byte[]>(data);
            try {
                FileChannel channel = this.cache.getChannel();
                channel.write(ByteBuffer.wrap(data), 16384L * (long)index);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAndDelete() {
        FileFrameCache fileFrameCache = this;
        synchronized (fileFrameCache) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cache is already closed");
            this.closed = true;
            try {
                this.cache.close();
                if (!this.file.delete()) {
                    if (!this.file.exists()) {
                        LOGGER.warn("Failed to delete cache file: {} (File does not exist)", (Object)this.file.getName());
                    } else {
                        LOGGER.warn("Failed to delete cache file: {}", (Object)this.file.getName());
                    }
                }
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

