/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core.clientside;

import com.google.common.base.Preconditions;
import de.pianoman911.mapengine.api.clientside.IMapDisplay;
import de.pianoman911.mapengine.api.pipeline.IPipeline;
import de.pianoman911.mapengine.common.data.MapUpdateData;
import de.pianoman911.mapengine.common.platform.PacketContainer;
import de.pianoman911.mapengine.core.MapEnginePlugin;
import de.pianoman911.mapengine.core.clientside.Frame;
import de.pianoman911.mapengine.core.pipeline.Pipeline;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.util.BlockVector;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Range;

public class FrameContainer
implements IMapDisplay {
    private final Frame[] frames;
    private final int width;
    private final int height;
    private final MapEnginePlugin plugin;
    private final Pipeline pipeline;
    private final BlockFace direction;
    private final BlockFace visualDirection;
    private final BoundingBox box;
    private final BoundingBox interactionBox;
    private double interactDistance = 6.0;
    private boolean glowing = true;

    @Deprecated
    public FrameContainer(BlockVector a, BlockVector b, BlockFace direction, MapEnginePlugin plugin, Pipeline pipeline) {
        this(a, b, direction, direction, plugin, pipeline);
    }

    public FrameContainer(BlockVector a, BlockVector b, BlockFace direction, BlockFace visualDirection, MapEnginePlugin plugin, Pipeline pipeline) {
        this.plugin = plugin;
        this.pipeline = pipeline;
        this.direction = direction;
        this.visualDirection = visualDirection;
        BlockVector min = new BlockVector(Math.min(a.getBlockX(), b.getBlockX()), Math.min(a.getBlockY(), b.getBlockY()), Math.min(a.getBlockZ(), b.getBlockZ()));
        BlockVector max = new BlockVector(Math.max(a.getBlockX(), b.getBlockX()), Math.max(a.getBlockY(), b.getBlockY()), Math.max(a.getBlockZ(), b.getBlockZ()));
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                max.setX(max.getBlockX() + 1);
                max.setY(max.getBlockY() + 1);
                this.width = max.getBlockX() - min.getBlockX();
                this.height = max.getBlockY() - min.getBlockY();
                this.frames = new Frame[this.width * this.height];
                for (int i = 0; i < this.frames.length; ++i) {
                    int x = i % this.width;
                    int y = i / this.width;
                    x = direction == BlockFace.NORTH ? max.getBlockX() - x - 1 : min.getBlockX() + x;
                    this.frames[i] = new Frame(plugin, direction, new BlockVector(x, max.getBlockY() - y - 1, max.getBlockZ()));
                }
                if (direction != BlockFace.NORTH) break;
                min.setZ(min.getBlockZ() + 1);
                max.setZ(max.getBlockZ() + 1);
                break;
            }
            case EAST: 
            case WEST: {
                max.setY(max.getBlockY() + 1);
                max.setZ(max.getBlockZ() + 1);
                this.width = max.getBlockZ() - min.getBlockZ();
                this.height = max.getBlockY() - min.getBlockY();
                this.frames = new Frame[this.width * this.height];
                for (int i = 0; i < this.frames.length; ++i) {
                    int z = i % this.width;
                    int y = i / this.width;
                    z = direction == BlockFace.EAST ? max.getBlockZ() - z - 1 : min.getBlockZ() + z;
                    this.frames[i] = new Frame(plugin, direction, new BlockVector(max.getBlockX(), max.getBlockY() - y - 1, z));
                }
                if (direction != BlockFace.WEST) break;
                min.setX(min.getBlockX() + 1);
                max.setX(max.getBlockX() + 1);
                break;
            }
            case UP: 
            case DOWN: {
                max.setX(max.getBlockX() + 1);
                max.setZ(max.getBlockZ() + 1);
                this.width = max.getBlockX() - min.getBlockX();
                this.height = max.getBlockZ() - min.getBlockZ();
                this.frames = new Frame[this.width * this.height];
                for (int i = 0; i < this.frames.length; ++i) {
                    int x = i % this.width;
                    int z = i / this.width;
                    z = direction == BlockFace.DOWN ? max.getBlockZ() - z - 1 : min.getBlockZ() + z;
                    this.frames[i] = new Frame(plugin, direction, new BlockVector(min.getBlockX() + x, max.getBlockY(), z));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction: " + String.valueOf(direction));
            }
        }
        this.box = BoundingBox.of((Vector)min, (Vector)max);
        switch (direction) {
            case NORTH: {
                this.interactionBox = this.box.clone().shift(0.0, 0.0, -0.0078125);
                break;
            }
            case SOUTH: {
                this.interactionBox = this.box.clone().shift(0.0, 0.0, 0.0078125);
                break;
            }
            case EAST: {
                this.interactionBox = this.box.clone().shift(0.0078125, 0.0, 0.0);
                break;
            }
            case WEST: {
                this.interactionBox = this.box.clone().shift(-0.0078125, 0.0, 0.0);
                break;
            }
            case UP: {
                this.interactionBox = this.box.clone().shift(0.0, 0.0078125, 0.0);
                break;
            }
            case DOWN: {
                this.interactionBox = this.box.clone().shift(0.0, -0.0078125, 0.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction: " + String.valueOf(direction));
            }
        }
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public int pixelWidth() {
        return this.width * 128;
    }

    @Override
    public int pixelHeight() {
        return this.height * 128;
    }

    @Override
    public BoundingBox box() {
        return this.box;
    }

    @Override
    public BlockFace direction() {
        return this.direction;
    }

    @Override
    public BlockFace visualDirection() {
        return this.visualDirection;
    }

    @Override
    public double interactDistance() {
        return this.interactDistance;
    }

    @Override
    public void interactDistance(double interactDistance) {
        this.interactDistance = interactDistance;
    }

    @Override
    public void spawn(Player player, int z) {
        this.spawn0(player, this.visualDirection, z);
    }

    @Override
    public void despawn(Player player) {
        IntArrayList ids = new IntArrayList();
        for (Frame frame : this.frames) {
            ids.add(frame.entityId);
            ids.add(frame.interactionId);
        }
        this.plugin.platform().createRemoveEntitiesPacket((IntList)ids).send(player);
        this.plugin.platform().flush(player);
    }

    @Override
    public void mapId(Player player, int z) {
        for (Frame frame : this.frames) {
            frame.setIdPacket(z, true).send(player);
        }
        this.plugin.platform().flush(player);
    }

    public void update(Player player, MapUpdateData[] data, int z, MapCursorCollection cursors, boolean bundling) {
        PacketContainer[] packets = new PacketContainer[this.frames.length];
        for (int i = 0; i < this.frames.length; ++i) {
            if (data[i].empty()) continue;
            PacketContainer<?> container = this.frames[i].updatePacket(data[i], z, cursors);
            if (bundling) {
                packets[i] = container;
                continue;
            }
            container.send(player);
        }
        if (bundling) {
            this.plugin.platform().sendBundled(player, packets);
        }
        this.plugin.platform().flush(player);
    }

    @Override
    public IPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public void destroy() {
        this.plugin.mapManager().removeDisplay(this);
        this.pipeline.destroy();
    }

    @Override
    public void rotation(Player player, float yaw, float pitch) {
        for (Frame frame : this.frames) {
            frame.rotationPacket(yaw, pitch).send(player);
        }
        this.plugin.platform().flush(player);
    }

    @Override
    public void itemRotation(Player player, @Range(from=0L, to=7L) int rotation) {
        for (Frame frame : this.frames) {
            frame.itemRotationPacket(rotation).send(player);
        }
        this.plugin.platform().flush(player);
    }

    @Override
    public void visualDirection(Player player, BlockFace visualDirection) {
        this.spawn0(player, visualDirection, 0);
    }

    @Override
    public void visualDirection(Player player, BlockFace visualDirection, int z) {
        this.spawn0(player, visualDirection, z);
    }

    @Override
    public boolean glowing() {
        return this.glowing;
    }

    @Override
    public void glowing(boolean glowing) {
        this.glowing = glowing;
    }

    @Override
    public void cloneGroupIds(IMapDisplay source) {
        Preconditions.checkNotNull((Object)source, (Object)"Source display cannot be null");
        FrameContainer other = (FrameContainer)source;
        Preconditions.checkArgument((other.height == this.height ? 1 : 0) != 0, (Object)"Height must be equal");
        Preconditions.checkArgument((other.width == this.width ? 1 : 0) != 0, (Object)"Width must be equal");
        for (int i = 0; i < this.frames.length; ++i) {
            Frame frame = this.frames[i];
            frame.mapIds(other.frames[i].mapIds0());
        }
    }

    @Override
    public void cutOffCloneGroupIds() {
        for (Frame frame : this.frames) {
            frame.mapIds((Int2IntMap)new Int2IntArrayMap());
        }
    }

    public Frame[] frames() {
        return this.frames;
    }

    private void spawn0(Player player, BlockFace visualDirection, int z) {
        for (Frame frame : this.frames) {
            frame.spawnPacket(visualDirection, this.glowing).send(player);
            frame.interactionEntity().send(player);
            frame.interactionEntitySize().send(player);
            frame.setIdPacket(z, true).send(player);
        }
        this.plugin.platform().flush(player);
    }

    public boolean hasEntity(int entityId) {
        for (Frame frame : this.frames) {
            if (frame.entityId != entityId) continue;
            return true;
        }
        return false;
    }

    public boolean isInteraction(int entityId) {
        for (Frame frame : this.frames) {
            if (frame.interactionId != entityId) continue;
            return true;
        }
        return false;
    }

    public boolean hasBlock(BlockVector blockVector) {
        for (Frame frame : this.frames) {
            if (!frame.pos.equals((Object)blockVector)) continue;
            return true;
        }
        return false;
    }

    public BoundingBox interactionBox() {
        return this.interactionBox;
    }
}

