/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core.drawing;

import de.pianoman911.mapengine.api.drawing.IDrawingSpace;
import de.pianoman911.mapengine.api.pipeline.IPipelineContext;
import de.pianoman911.mapengine.api.util.Alignment;
import de.pianoman911.mapengine.api.util.FontRegistry;
import de.pianoman911.mapengine.api.util.FullSpacedColorBuffer;
import de.pianoman911.mapengine.api.util.ImageUtils;
import de.pianoman911.mapengine.core.pipeline.PipelineContext;
import de.pianoman911.mapengine.core.util.ComponentUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.apache.commons.lang3.StringUtils;

public record DrawingSpace(FullSpacedColorBuffer buffer, PipelineContext context) implements IDrawingSpace
{
    public static final int ALPHA = 0;

    @Override
    public IPipelineContext ctx() {
        return this.context;
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer.buffer(), 0);
    }

    @Override
    public void clear(int x, int y, int width, int height) {
        for (int i = 0; i < height; ++i) {
            Arrays.fill(this.buffer.buffer(), x + (y + i) * this.buffer.width(), x + (y + i) * this.buffer.width() + width, 0);
        }
    }

    @Override
    public void pixel(int x, int y, int color) {
        this.buffer.pixel(x, y, color);
    }

    @Override
    public void pixels(int[] pixels, int x, int y, int width, int height) {
        this.buffer.pixels(pixels, x, y, width, height);
    }

    @Override
    public void buffer(FullSpacedColorBuffer buffer, int x, int y) {
        this.buffer.buffer(buffer, x, y);
    }

    @Override
    public void line(int x1, int y1, int x2, int y2, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            this.pixel(x1, y1, color);
            if (x1 == x2 && y1 == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x1 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y1 += sy;
        }
    }

    @Override
    public void line(int x1, int y1, int x2, int y2, int thickness, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            this.rect(x1, y1, thickness, thickness, color);
            if (x1 == x2 && y1 == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x1 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y1 += sy;
        }
    }

    @Override
    public void rect(int x, int y, int width, int height, int thickness, int color) {
        int xMax = x + width;
        int yMax = y + height;
        this.rect(x, y, xMax - x, thickness, color);
        this.rect(x, yMax - thickness, xMax - x, thickness, color);
        this.rect(x, y + thickness, thickness, height - 2 * thickness, color);
        this.rect(xMax - thickness, y + thickness, thickness, height - 2 * thickness, color);
    }

    @Override
    public void rect(int x, int y, int width, int height, int color) {
        for (int posY = 0; posY < height; ++posY) {
            for (int posX = 0; posX < width; ++posX) {
                this.pixel(x + posX, y + posY, color);
            }
        }
    }

    @Override
    public void circle(int x, int y, int radius, int color) {
        this.ellipse(x, y, radius, radius, color);
    }

    @Override
    public void circle(int x, int y, int radius, int thickness, int color) {
        this.ellipse(x, y, radius, radius, thickness, color);
    }

    @Override
    public void ellipse(int x, int y, int radiusX, int radiusY, int color) {
        if ((color >> 24 & 0xFF) == 255) {
            this.fastEllipse(x, y, radiusX, radiusY, color);
            return;
        }
        long radiusX2 = (long)radiusX * (long)radiusX;
        long radiusY2 = (long)radiusY * (long)radiusY;
        long radiusX2Y2 = radiusX2 * radiusY2;
        for (int posY = -radiusY; posY < radiusY; ++posY) {
            long posY2RadiusX2 = (long)posY * (long)posY * radiusX2;
            for (int posX = -radiusX; posX < radiusX; ++posX) {
                long posX2 = (long)posX * (long)posX;
                if (posX2 * radiusY2 + posY2RadiusX2 >= radiusX2Y2) continue;
                this.pixel(x + posX, y + posY, color);
            }
        }
    }

    private void fastEllipse(int x, int y, int radiusX, int radiusY, int color) {
        long radiusX2 = (long)radiusX * (long)radiusX;
        long radiusY2 = (long)radiusY * (long)radiusY;
        double radiusX2Y2 = radiusX2 * radiusY2;
        for (int posY = 0; posY < radiusY; ++posY) {
            int xLimit = (int)Math.ceil(Math.sqrt((radiusX2Y2 - (double)((long)(posY * posY) * radiusX2)) / (double)radiusY2));
            for (int posX = 0; posX <= xLimit; ++posX) {
                this.pixel(x + posX, y + posY, color);
                this.pixel(x - posX, y + posY, color);
                this.pixel(x + posX, y - posY, color);
                this.pixel(x - posX, y - posY, color);
            }
        }
    }

    @Override
    public void ellipse(int x, int y, int radiusX, int radiusY, int thickness, int color) {
        int negativeRadiusYThickness;
        if ((color >> 24 & 0xFF) == 255) {
            this.fastEllipse(x, y, radiusX, radiusY, thickness, color);
            return;
        }
        double t = (double)thickness / 2.0;
        double innerRadiusY2 = ((double)radiusY - t) * ((double)radiusY - t);
        double innerRadiusX2 = ((double)radiusX - t) * ((double)radiusX - t);
        double outerRadiusY2 = ((double)radiusY + t) * ((double)radiusY + t);
        double outerRadiusX2 = ((double)radiusX + t) * ((double)radiusX + t);
        double outerRadiusX2Y2 = outerRadiusX2 * outerRadiusY2;
        double innerRadiusX2Y2 = innerRadiusX2 * innerRadiusY2;
        int radiusXThickness = radiusX + thickness;
        int negativeRadiusXThickness = -radiusXThickness;
        int radiusYThickness = radiusY + thickness;
        for (int posY = negativeRadiusYThickness = -radiusYThickness; posY < radiusYThickness; ++posY) {
            double posY2 = posY * posY;
            for (int posX = negativeRadiusXThickness; posX < radiusXThickness; ++posX) {
                double posX2 = posX * posX;
                if (!(posX2 * outerRadiusY2 + posY2 * outerRadiusX2 < outerRadiusX2Y2) || !(posX2 * innerRadiusY2 + posY2 * innerRadiusX2 > innerRadiusX2Y2)) continue;
                this.pixel(x + posX, y + posY, color);
            }
        }
    }

    private void fastEllipse(int x, int y, int radiusX, int radiusY, int thickness, int color) {
        double t = (double)thickness / 2.0;
        double innerRadiusY2 = ((double)radiusY - t) * ((double)radiusY - t);
        double innerRadiusX2 = ((double)radiusX - t) * ((double)radiusX - t);
        double outerRadiusY2 = ((double)radiusY + t) * ((double)radiusY + t);
        double outerRadiusX2 = ((double)radiusX + t) * ((double)radiusX + t);
        double innerRadiusX2Y2 = innerRadiusX2 * innerRadiusY2;
        double outerRadiusX2Y2 = outerRadiusX2 * outerRadiusY2;
        int yLimit = (int)Math.ceil(Math.sqrt(outerRadiusX2Y2 / outerRadiusY2));
        for (int posY = 0; posY <= yLimit; ++posY) {
            int xLowerLimit = (int)Math.ceil(Math.sqrt((innerRadiusX2Y2 - (double)(posY * posY) * innerRadiusX2) / innerRadiusY2));
            double xUpperLimit = Math.sqrt((outerRadiusX2Y2 - (double)(posY * posY) * outerRadiusX2) / outerRadiusY2);
            int posX = xLowerLimit;
            while ((double)posX <= xUpperLimit) {
                this.pixel(x + posX, y + posY, color);
                this.pixel(x - posX, y + posY, color);
                this.pixel(x + posX, y - posY, color);
                this.pixel(x - posX, y - posY, color);
                ++posX;
            }
        }
    }

    @Override
    public void triangle(int x1, int y1, int x2, int y2, int x3, int y3, int color) {
        for (int posY = 0; posY < this.buffer.height(); ++posY) {
            for (int posX = 0; posX < this.buffer.width(); ++posX) {
                boolean side;
                int as_x;
                int as_y;
                if ((x3 - x1) * as_y - (y3 - y1) * as_x > 0 == (side = (x2 - x1) * (as_y = posY - y1) - (y2 - y1) * (as_x = posX - x1) > 0) || (x3 - x2) * (posY - y2) - (y3 - y2) * (posX - x2) > 0 != side) continue;
                this.pixel(posX, posY, color);
            }
        }
    }

    @Override
    public void triangle(int x1, int y1, int x2, int y2, int x3, int y3, int thickness, int color) {
        this.line(x1, y1, x2, y2, thickness, color);
        this.line(x2, y2, x3, y3, thickness, color);
        this.line(x3, y3, x1, y1, thickness, color);
    }

    @Override
    public void polygon(int[] x, int[] y, int thickness, int color) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y must have the same length");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("x and y must have at least 3 points");
        }
        if (x.length == 3) {
            this.triangle(x[0], y[0], x[1], y[1], x[2], y[2], thickness, color);
            return;
        }
        if (x.length == 4) {
            this.rect(x[0], y[0], x[2] - x[0], y[2] - y[0], thickness, color);
            return;
        }
        for (int i = 0; i < x.length; ++i) {
            this.line(x[i], y[i], x[(i + 1) % x.length], y[(i + 1) % x.length], thickness, color);
        }
    }

    @Override
    public void polygon(int[] x, int[] y, int color) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y must have the same length");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("x and y must have at least 3 points");
        }
        if (x.length == 3) {
            this.triangle(x[0], y[0], x[1], y[1], x[2], y[2], color);
            return;
        }
        if (x.length == 4) {
            this.rect(x[0], y[0], x[2] - x[0], y[2] - y[0], color);
            return;
        }
        for (int posY = 0; posY < this.buffer.height(); ++posY) {
            for (int posX = 0; posX < this.buffer.width(); ++posX) {
                boolean inside = false;
                int i = 0;
                int j = x.length - 1;
                while (i < x.length) {
                    if (y[i] > posY != y[j] > posY && posX < (x[j] - x[i]) * (posY - y[i]) / (y[j] - y[i]) + x[i]) {
                        inside = !inside;
                    }
                    j = i++;
                }
                if (!inside) continue;
                this.pixel(posX, posY, color);
            }
        }
    }

    @Override
    public void text(String text, Font font, int x, int y, int color) {
        this.component((Component)Component.text((String)text), font, x, y, Alignment.START, Alignment.CENTER, false);
    }

    @Override
    public void component(Component component, Font font, int x, int y) {
        this.component(component, font, x, y, Alignment.START, Alignment.CENTER);
    }

    @Override
    public void component(Component component, Font font, int x, int y, Alignment alignmentX, Alignment alignmentY) {
        this.component(component, font, x, y, alignmentX, alignmentY, true);
    }

    @Override
    public void component(Component component, Font font, int x, int y, Alignment alignmentX, Alignment alignmentY, boolean antiAliasing) {
        this.component(component, font, x, y, alignmentX, alignmentY, antiAliasing, 1.2f);
    }

    @Override
    public void component(Component component, Font font, int x, int y, Alignment alignmentX, Alignment alignmentY, boolean antiAliasing, float lineHeight) {
        List<Component> inlined = ComponentUtil.inlineComponent(component);
        ArrayList<LinePartData> buffers = new ArrayList<LinePartData>(inlined.size() * 2);
        IntArrayList lineWidths = new IntArrayList();
        int lastWidth = 0;
        for (Component child : inlined) {
            String content = PlainTextComponentSerializer.plainText().serialize(child);
            if (content.isEmpty()) continue;
            TextColor componentColor = child.color();
            Color color = componentColor == null ? Color.WHITE : new Color(componentColor.value());
            String[] parts = StringUtils.splitPreserveAllTokens((String)content, (char)'\n');
            for (int i = 0; i < parts.length; ++i) {
                int currentWidth;
                boolean breakLine = i > 0;
                String part = parts[i];
                FullSpacedColorBuffer childBuf = part.isEmpty() ? FontRegistry.EMPTY_BUFFER : FontRegistry.convertText2Bytes(part, font, color, antiAliasing);
                buffers.add(new LinePartData(childBuf, breakLine));
                int bufWidth = childBuf.width();
                int n = currentWidth = breakLine ? bufWidth : bufWidth + lastWidth;
                if (breakLine) {
                    lineWidths.add(lastWidth);
                }
                lastWidth = currentWidth;
            }
        }
        lineWidths.add(lastWidth);
        int offsetY = alignmentY.getOffset((int)((float)font.getSize() * lineHeight * (float)lineWidths.size()));
        int currentX = 0;
        int line = 0;
        for (LinePartData part : buffers) {
            FullSpacedColorBuffer renderedLine = part.buffer();
            if (part.breakLine()) {
                ++line;
                y += (int)((float)font.getSize() * lineHeight);
                currentX = 0;
            }
            if (renderedLine.size() <= 0) continue;
            int lineWidth = lineWidths.getInt(line);
            int lineOffsetX = alignmentX.getOffset(lineWidth);
            int posX = x + lineOffsetX + currentX;
            this.buffer.buffer(renderedLine, posX, y + offsetY);
            currentX += renderedLine.width();
        }
    }

    @Override
    public void image(BufferedImage image, int x, int y) {
        this.buffer.pixels(ImageUtils.rgb(image), x, y, image.getWidth(), image.getHeight());
    }

    private record LinePartData(FullSpacedColorBuffer buffer, boolean breakLine) {
    }
}

