/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core.pipeline;

import de.pianoman911.mapengine.api.pipeline.IPipelineContext;
import de.pianoman911.mapengine.api.pipeline.IPipelineOutput;
import de.pianoman911.mapengine.api.util.ColorBuffer;
import de.pianoman911.mapengine.api.util.Converter;
import de.pianoman911.mapengine.api.util.FullSpacedColorBuffer;
import de.pianoman911.mapengine.core.MapEnginePlugin;
import de.pianoman911.mapengine.core.cache.FileFrameCache;
import de.pianoman911.mapengine.core.cache.FrameCache;
import de.pianoman911.mapengine.core.cache.NullFrameCache;
import de.pianoman911.mapengine.core.colors.dithering.FloydSteinbergDithering;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bukkit.entity.Player;

public abstract class BaseDisplayOutput
implements IPipelineOutput {
    protected static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private static final Set<BaseDisplayOutput> INSTANCES = new HashSet<BaseDisplayOutput>();
    protected final MapEnginePlugin plugin;
    private final Map<UUID, Map<Integer, FrameCache>> cache = new HashMap<UUID, Map<Integer, FrameCache>>();
    private final Set<Player> preventBuffering = Collections.newSetFromMap(new WeakHashMap());
    private boolean destroyed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseDisplayOutput(MapEnginePlugin plugin) {
        this.plugin = plugin;
        Set<BaseDisplayOutput> set = INSTANCES;
        synchronized (set) {
            INSTANCES.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ejectPlayer(Player player) {
        Set<BaseDisplayOutput> instances;
        Set<BaseDisplayOutput> set = INSTANCES;
        synchronized (set) {
            instances = Set.copyOf(INSTANCES);
        }
        for (BaseDisplayOutput instance : instances) {
            Map<UUID, Map<Integer, FrameCache>> map = instance.cache;
            synchronized (map) {
                Set<Player> set2 = instance.preventBuffering;
                synchronized (set2) {
                    instance.preventBuffering.add(player);
                }
                Map<Integer, FrameCache> zs = instance.cache.remove(player.getUniqueId());
                if (zs != null) {
                    for (FrameCache cache : zs.values()) {
                        cache.closeAndDelete();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FrameCache getFrameFileCache(Player receiver, int z, int size) {
        if (this.destroyed) {
            return NullFrameCache.INSTANCE;
        }
        Map<UUID, Map<Integer, FrameCache>> map = this.cache;
        synchronized (map) {
            Set<Player> set = this.preventBuffering;
            synchronized (set) {
                if (this.preventBuffering.contains(receiver)) {
                    return NullFrameCache.INSTANCE;
                }
            }
            return this.cache.computeIfAbsent(receiver.getUniqueId(), uuid -> new HashMap()).computeIfAbsent(z, $ -> new FileFrameCache(new File(String.valueOf(this.plugin.getDataFolder()) + "/caches", String.valueOf(UUID.randomUUID()) + ".cache"), size));
        }
    }

    protected ColorBuffer convert(FullSpacedColorBuffer buffer, IPipelineContext ctx, int frameHeight) {
        return switch (ctx.converter()) {
            default -> throw new IncompatibleClassChangeError();
            case Converter.DIRECT -> this.plugin.colorPalette().convertDirect(buffer);
            case Converter.FLOYD_STEINBERG -> FloydSteinbergDithering.dither(buffer, this.plugin.colorPalette(), frameHeight);
        };
    }

    protected void removeOfflinePlayers(IPipelineContext ctx) {
        ctx.receivers().removeIf(player -> !player.isOnline());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.destroyed = true;
        Object object = INSTANCES;
        synchronized (object) {
            INSTANCES.remove(this);
        }
        object = this.cache;
        synchronized (object) {
            for (Map<Integer, FrameCache> caches : this.cache.values()) {
                for (FrameCache cache : caches.values()) {
                    cache.closeAndDelete();
                }
            }
        }
    }
}

