/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core.platform;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.pianoman911.mapengine.api.event.MapClickEvent;
import de.pianoman911.mapengine.api.util.MapClickType;
import de.pianoman911.mapengine.api.util.MapTraceResult;
import de.pianoman911.mapengine.api.util.PassthroughMode;
import de.pianoman911.mapengine.api.util.Vec2i;
import de.pianoman911.mapengine.common.platform.IListenerBridge;
import de.pianoman911.mapengine.core.MapEnginePlugin;
import de.pianoman911.mapengine.core.clientside.FrameContainer;
import de.pianoman911.mapengine.core.util.MapUtil;
import it.unimi.dsi.fastutil.Pair;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public final class ImplListenerBridge
implements IListenerBridge {
    private static final Cache<Player, PassthroughMode> CLICKED = CacheBuilder.newBuilder().expireAfterWrite(100L, TimeUnit.MILLISECONDS).weakKeys().build();
    private final MapEnginePlugin plugin;

    public ImplListenerBridge(MapEnginePlugin plugin) {
        this.plugin = plugin;
    }

    private FrameContainer checkMap(Player player, int entityId) {
        return this.plugin.mapManager().display(entityId);
    }

    private PassthroughMode getLastPacketMode(Player player) {
        return (PassthroughMode)((Object)CLICKED.getIfPresent((Object)player));
    }

    private PassthroughMode handleRawClick(Player player, int entityId, Function<FrameContainer, PassthroughMode> handler) {
        FrameContainer map;
        PassthroughMode last = this.getLastPacketMode(player);
        if (last == null && (map = this.checkMap(player, entityId)) != null && (last = handler.apply(map)) != null) {
            CLICKED.put((Object)player, (Object)(last == PassthroughMode.ALL ? PassthroughMode.ALL : PassthroughMode.NONE));
        }
        return last;
    }

    private PassthroughMode executeAtExactPosition(Player player, FrameContainer map, MapClickType type) {
        Pair<Vector, Vec2i> clickPos = MapUtil.calculateClickPosition(player, map, map.interactDistance());
        if (clickPos != null) {
            return this.callClickEvent(player, map, type, (Vec2i)clickPos.right(), (Vector)clickPos.left());
        }
        return null;
    }

    private PassthroughMode callClickEvent(Player player, FrameContainer map, MapClickType type, Vec2i clickPos, Vector interactionPos) {
        Location worldPos = interactionPos.toLocation(player.getWorld());
        return this.callClickEvent(player, map, type, clickPos, worldPos);
    }

    private PassthroughMode callClickEvent(Player player, FrameContainer map, MapClickType type, Vec2i clickPos, Location worldPos) {
        double interactDistance = worldPos.distance(player.getEyeLocation());
        MapClickEvent clickEvent = new MapClickEvent(map, type, player, clickPos, worldPos, interactDistance);
        clickEvent.callEvent();
        return clickEvent.passthroughMode();
    }

    @Override
    public PassthroughMode handleInteract(Player player, int entityId, double posX, double posY, double posZ) {
        return this.handleRawClick(player, entityId, map -> {
            block14: {
                switch (map.direction()) {
                    case EAST: {
                        if (posX >= 0.4374) {
                            break;
                        }
                        break block14;
                    }
                    case WEST: {
                        if (posX <= -0.4374) {
                            break;
                        }
                        break block14;
                    }
                    case SOUTH: {
                        if (posZ >= 0.4374) {
                            break;
                        }
                        break block14;
                    }
                    case NORTH: {
                        if (posZ <= -0.4374) {
                            break;
                        }
                        break block14;
                    }
                    case UP: {
                        if (posY >= 0.9374) {
                            break;
                        }
                        break block14;
                    }
                    case DOWN: {
                        if (posY <= 0.0626) {
                            break;
                        }
                        break block14;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported direction: " + String.valueOf(map.direction()));
                    }
                }
                return this.executeAtExactPosition(player, (FrameContainer)map, MapClickType.RIGHT_CLICK);
            }
            return null;
        });
    }

    @Override
    public PassthroughMode handleAttack(Player player, int entityId) {
        return this.handleRawClick(player, entityId, map -> this.executeAtExactPosition(player, (FrameContainer)map, MapClickType.LEFT_CLICK));
    }

    @Override
    public PassthroughMode handleSwing(Player player) {
        PassthroughMode lastMode = this.getLastPacketMode(player);
        if (lastMode != null) {
            return lastMode;
        }
        MapTraceResult result = this.plugin.mapManager().traceDisplayInView(player);
        if (result == null) {
            return null;
        }
        PassthroughMode passthroughMode = this.callClickEvent(player, (FrameContainer)result.display(), MapClickType.LEFT_CLICK, result.viewPos(), result.worldPos());
        CLICKED.put((Object)player, (Object)PassthroughMode.NONE);
        return passthroughMode;
    }
}

