/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core.platform;

import com.google.common.base.Preconditions;
import de.pianoman911.mapengine.common.platform.IListenerBridge;
import de.pianoman911.mapengine.common.platform.IPlatform;
import de.pianoman911.mapengine.common.platform.IPlatformProvider;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlatformUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"MapEngine");

    private PlatformUtil() {
    }

    private static List<IPlatformProvider> getProviders(ClassLoader loader) {
        Preconditions.checkArgument((boolean)(loader instanceof URLClassLoader), (Object)"Loader is not an instance of URLClassLoader");
        ArrayList<IPlatformProvider> providers = new ArrayList<IPlatformProvider>();
        for (URL url : ((URLClassLoader)loader).getURLs()) {
            Path sourcePath;
            try {
                sourcePath = new File(url.toURI()).toPath();
            }
            catch (URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
            try (FileSystem fs = FileSystems.newFileSystem(sourcePath);){
                for (Path rootDir : fs.getRootDirectories()) {
                    PlatformUtil.extractProviders(rootDir, loader, providers);
                }
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        return Collections.unmodifiableList(providers);
    }

    private static void extractProviders(Path rootDir, ClassLoader loader, List<IPlatformProvider> providers) {
        try (Stream<Path> files = Files.list(rootDir);){
            files.filter(path -> path.getFileName().toString().startsWith("provider_")).map(path -> {
                try {
                    return Files.readString(path).trim();
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }).map(className -> {
                try {
                    return loader.loadClass((String)className).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (UnsupportedClassVersionError exception) {
                    LOGGER.debug("Can't load provider class {} due to unsupported class version, skipping...", className);
                    return null;
                }
                catch (ReflectiveOperationException exception) {
                    throw new RuntimeException(exception);
                }
            }).filter(Objects::nonNull).map(obj -> (IPlatformProvider)obj).forEach(providers::add);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static IPlatform<?> getPlatform(Plugin plugin, ClassLoader loader, IListenerBridge bridge) {
        return (IPlatform)PlatformUtil.getProviders(loader).stream().sorted().flatMap(provider -> provider.tryProvide(plugin, bridge).stream()).findFirst().orElseThrow(() -> new UnsupportedOperationException("Unsupported server version/software"));
    }
}

