/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.api.clientside;

import de.pianoman911.mapengine.api.clientside.IDisplay;
import de.pianoman911.mapengine.api.clientside.IFrame;
import de.pianoman911.mapengine.api.util.Vec2i;
import java.util.function.BiConsumer;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.Range;

public interface IMapDisplay
extends IDisplay {
    @Override
    public void destroy();

    public int width();

    public int height();

    public BoundingBox box();

    public BlockFace direction();

    public BlockFace visualDirection();

    public double interactDistance();

    public void interactDistance(double var1);

    default public void spawn(Player player) {
        this.spawn(player, 0);
    }

    public void spawn(Player var1, int var2);

    public void despawn(Player var1);

    public void mapId(Player var1, int var2);

    public void rotation(Player var1, float var2, float var3);

    public void itemRotation(Player var1, @Range(from=0L, to=7L) int var2);

    public void visualDirection(Player var1, BlockFace var2);

    public void visualDirection(Player var1, BlockFace var2, int var3);

    public boolean glowing();

    public void glowing(boolean var1);

    public void cloneGroupIds(IMapDisplay var1);

    public void cutOffCloneGroupIds();

    public IFrame[] frames();

    default public IFrame frameAt(int x, int y) {
        int width = this.width();
        if (x < 0 || x >= width || y < 0 || y >= this.height()) {
            throw new ArrayIndexOutOfBoundsException("x or y position is out of bounds");
        }
        return this.frames()[x + y * width];
    }

    default public void consumeFrames(BiConsumer<IFrame, Vec2i> consumer) {
        IFrame[] frames = this.frames();
        int w = this.width();
        int h = this.height();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                consumer.accept(frames[x + y * w], new Vec2i(x, y));
            }
        }
    }
}

