/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.api.event;

import de.pianoman911.mapengine.api.clientside.IMapDisplay;
import de.pianoman911.mapengine.api.event.MapEvent;
import de.pianoman911.mapengine.api.util.MapClickType;
import de.pianoman911.mapengine.api.util.PassthroughMode;
import de.pianoman911.mapengine.api.util.Vec2i;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MapClickEvent
extends MapEvent {
    private final MapClickType clickType;
    private final Player player;
    private final Vec2i clickPos;
    private final Location worldPos;
    private final double interactDistance;
    private PassthroughMode passthroughMode = PassthroughMode.ALL;

    public MapClickEvent(IMapDisplay display, MapClickType clickType, Player player, Vec2i clickPos, Location worldPos, double interactDistance) {
        super(display);
        this.clickType = clickType;
        this.player = player;
        this.clickPos = clickPos;
        this.worldPos = worldPos;
        this.interactDistance = interactDistance;
    }

    public MapClickType clickType() {
        return this.clickType;
    }

    public Player player() {
        return this.player;
    }

    public int x() {
        return this.clickPos.x();
    }

    public int y() {
        return this.clickPos.y();
    }

    public Vec2i asVec2i() {
        return this.clickPos;
    }

    public Location worldPos() {
        return this.worldPos;
    }

    public double interactDistance() {
        return this.interactDistance;
    }

    @NotNull
    public PassthroughMode passthroughMode() {
        return this.passthroughMode;
    }

    @Deprecated(forRemoval=true)
    public void setPassthroughMode(@NotNull PassthroughMode passthroughMode) {
        this.passthroughMode = passthroughMode;
    }

    public void passthroughMode(@NotNull PassthroughMode passthroughMode) {
        this.passthroughMode = passthroughMode;
    }

    public String toString() {
        return "MapClickEvent{clickType=" + String.valueOf((Object)this.clickType) + ", player=" + String.valueOf(this.player) + ", worldPos=" + String.valueOf(this.clickPos) + "}";
    }
}

