/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.api.pipeline;

import de.pianoman911.mapengine.api.clientside.IDisplay;
import de.pianoman911.mapengine.api.clientside.IMapDisplay;
import de.pianoman911.mapengine.api.drawing.IDrawingSpace;
import de.pianoman911.mapengine.api.drawing.ILayeredDrawingSpace;
import de.pianoman911.mapengine.api.pipeline.IPipeline;
import de.pianoman911.mapengine.api.pipeline.IPipelineContext;
import de.pianoman911.mapengine.api.pipeline.IPipelineOutput;
import de.pianoman911.mapengine.api.pipeline.IPipelineStream;
import de.pianoman911.mapengine.api.util.FullSpacedColorBuffer;

public interface IPipelineProvider {
    default public IPipeline createPipeline(IPipelineStream ... streams) {
        return this.createPipeline(this.createMapOutput(), streams);
    }

    public IPipeline createPipeline(IPipelineOutput var1, IPipelineStream ... var2);

    @Deprecated(forRemoval=true)
    default public IPipelineOutput output() {
        return this.createMapOutput();
    }

    public IPipelineOutput createMapOutput();

    public IPipelineOutput createHoldableOutput();

    @Deprecated(forRemoval=true)
    default public IDrawingSpace drawingSpace(IMapDisplay display) {
        return this.createDrawingSpace(display);
    }

    default public IDrawingSpace createDrawingSpace(IDisplay display) {
        return this.createDrawingSpace(display.pixelWidth(), display.pixelHeight(), display);
    }

    @Deprecated(forRemoval=true)
    default public IDrawingSpace drawingSpace(int width, int height, IMapDisplay display) {
        return this.createDrawingSpace(width, height, display);
    }

    default public IDrawingSpace createDrawingSpace(int width, int height, IDisplay display) {
        return this.createDrawingSpace(new FullSpacedColorBuffer(width, height), display);
    }

    @Deprecated(forRemoval=true)
    default public IDrawingSpace drawingSpace(FullSpacedColorBuffer buffer, IMapDisplay display) {
        return this.createDrawingSpace(buffer, display);
    }

    default public IDrawingSpace createDrawingSpace(FullSpacedColorBuffer buffer, IDisplay display) {
        return this.drawingSpace(this.createCtx(display), buffer);
    }

    default public IDrawingSpace drawingSpace(IPipelineContext ctx, int width, int height) {
        return this.drawingSpace(ctx, new FullSpacedColorBuffer(width, height));
    }

    public IDrawingSpace drawingSpace(IPipelineContext var1, FullSpacedColorBuffer var2);

    @Deprecated(forRemoval=true)
    default public ILayeredDrawingSpace layeredDrawingSpace(IMapDisplay display) {
        return this.createLayeredDrawingSpace(display);
    }

    default public ILayeredDrawingSpace createLayeredDrawingSpace(IDisplay display) {
        return this.createLayeredDrawingSpace(display.pixelWidth(), display.pixelHeight(), display);
    }

    @Deprecated(forRemoval=true)
    default public ILayeredDrawingSpace layeredDrawingSpace(int width, int height, IMapDisplay display) {
        return this.createLayeredDrawingSpace(width, height, display);
    }

    default public ILayeredDrawingSpace createLayeredDrawingSpace(int width, int height, IDisplay display) {
        return this.createLayeredDrawingSpace(new FullSpacedColorBuffer(width, height), display);
    }

    @Deprecated(forRemoval=true)
    default public ILayeredDrawingSpace layeredDrawingSpace(FullSpacedColorBuffer buffer, IMapDisplay display) {
        return this.createLayeredDrawingSpace(buffer, display);
    }

    default public ILayeredDrawingSpace createLayeredDrawingSpace(FullSpacedColorBuffer buffer, IDisplay display) {
        return this.layeredDrawingSpace(this.createCtx(display), buffer);
    }

    default public ILayeredDrawingSpace layeredDrawingSpace(IPipelineContext ctx, int width, int height) {
        return this.layeredDrawingSpace(ctx, new FullSpacedColorBuffer(width, height));
    }

    public ILayeredDrawingSpace layeredDrawingSpace(IPipelineContext var1, FullSpacedColorBuffer var2);

    @Deprecated(forRemoval=true)
    default public IPipelineContext ctx(IMapDisplay display) {
        return this.createCtx(display);
    }

    public IPipelineContext createCtx(IDisplay var1);
}

