/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.api.util;

import com.google.common.base.Preconditions;

public class ColorBuffer {
    private final byte[] data;
    private final int width;
    private final int height;

    public ColorBuffer(byte[] data, int width, int height) {
        Preconditions.checkState((data.length / width == height ? 1 : 0) != 0, (String)"Width %s and height %s invalid for rgb array with length %s", (Object)width, (Object)height, (Object)data.length);
        this.data = data;
        this.width = width;
        this.height = height;
    }

    @Deprecated
    public ColorBuffer(int size, int width, int height) {
        this(width, height);
    }

    public ColorBuffer(int width, int height) {
        this(new byte[width * height], width, height);
    }

    public final byte[] data() {
        return this.data;
    }

    public final int size() {
        return this.data.length;
    }

    public final int width() {
        return this.width;
    }

    public final int height() {
        return this.height;
    }
}

