/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.common.data;

import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public final class MapUpdateData {
    private static final byte[] EMPTY_ARR = new byte[0];
    private final byte[] fullBuffer;
    private final byte[] buffer;
    private final short beginX;
    private final short beginY;
    private final short endX;
    private final short endY;

    public MapUpdateData(byte[] fullBuffer, byte[] colors, long beginX, long beginY, long endX, long endY) {
        this.fullBuffer = fullBuffer;
        this.buffer = colors;
        this.beginX = (short)beginX;
        this.beginY = (short)beginY;
        this.endX = (short)endX;
        this.endY = (short)endY;
    }

    public static MapUpdateData createMapUpdateData(byte[] fullBuffer, byte @Nullable [] lastUpdateData, int minChanges) {
        if (lastUpdateData == null) {
            return MapUpdateData.createFull(fullBuffer);
        }
        short beginX = 128;
        short beginY = 128;
        short endX = 0;
        short endY = 0;
        int changes = 0;
        for (int i = 0; i < 16384; i = (int)((short)(i + 1))) {
            short x = (short)(i % 128);
            short y = (short)(i / 128);
            if (fullBuffer[i] == lastUpdateData[i]) continue;
            ++changes;
            if (x < beginX) {
                beginX = x;
            }
            if (y < beginY) {
                beginY = y;
            }
            if (x > endX) {
                endX = x;
            }
            if (y <= endY) continue;
            endY = y;
        }
        if (changes < minChanges || beginX == 128 && beginY == 128 && endX == 0 && endY == 0) {
            return MapUpdateData.createEmpty(fullBuffer);
        }
        endX = (short)(endX + 1);
        endY = (short)(endY + 1);
        byte[] colors = new byte[(endX - beginX) * (endY - beginY)];
        for (int i = 0; i < colors.length; i = (int)((short)(i + 1))) {
            short x = (short)(i % (endX - beginX));
            short y = (short)(i / (endX - beginX));
            colors[i] = fullBuffer[(y + beginY) * 128 + x + beginX];
        }
        return new MapUpdateData(fullBuffer, colors, beginX, beginY, endX, endY);
    }

    private static MapUpdateData createFull(byte[] colors) {
        return new MapUpdateData((byte[])colors.clone(), colors, 0L, 0L, 128L, 128L);
    }

    private static MapUpdateData createEmpty(byte[] fullBuffer) {
        return new MapUpdateData(fullBuffer, EMPTY_ARR, 0L, 0L, 0L, 0L);
    }

    public int size() {
        return this.buffer.length;
    }

    public boolean empty() {
        return this.buffer.length == 0;
    }

    public short offsetX() {
        return this.beginX;
    }

    public short offsetY() {
        return this.beginY;
    }

    public int width() {
        return this.endX - this.beginX;
    }

    public int height() {
        return this.endY - this.beginY;
    }

    public byte[] fullBuffer() {
        return this.fullBuffer;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public String toString() {
        return "MapUpdateData{fullBuffer=" + Arrays.toString(this.fullBuffer) + ", colors=" + Arrays.toString(this.buffer) + ", beginX=" + this.beginX + ", beginY=" + this.beginY + ", endX=" + this.endX + ", endY=" + this.endY + "}";
    }
}

