/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core;

import de.pianoman911.mapengine.api.MapEngineApi;
import de.pianoman911.mapengine.bstats.bukkit.Metrics;
import de.pianoman911.mapengine.common.platform.IPlatform;
import de.pianoman911.mapengine.core.api.ImplMapEngineApi;
import de.pianoman911.mapengine.core.colors.ColorPalette;
import de.pianoman911.mapengine.core.listener.MapEngineListener;
import de.pianoman911.mapengine.core.map.HoldableManager;
import de.pianoman911.mapengine.core.map.MapManager;
import de.pianoman911.mapengine.core.platform.ImplListenerBridge;
import de.pianoman911.mapengine.core.platform.PlatformUtil;
import de.pianoman911.mapengine.core.updater.MapEngineUpdater;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class MapEnginePlugin
extends JavaPlugin {
    private IPlatform<?> platform;
    private ColorPalette colorPalette;
    private MapManager mapManager;
    private HoldableManager holdableManager;
    private ImplMapEngineApi api;

    public void onLoad() {
        new Metrics(this, 18122);
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.platform = PlatformUtil.getPlatform((Plugin)this, this.getClassLoader(), new ImplListenerBridge(this));
        this.getSLF4JLogger().info("Using platform: {}", (Object)this.platform.getDisplayedName());
        this.colorPalette = new ColorPalette(this);
        this.mapManager = new MapManager(this);
        this.holdableManager = new HoldableManager(this);
        this.api = new ImplMapEngineApi(this);
        Bukkit.getServicesManager().register(MapEngineApi.class, (Object)this.api, (Plugin)this, ServicePriority.Normal);
        Bukkit.getPluginManager().registerEvents((Listener)new MapEngineListener(), (Plugin)this);
        if (this.getConfig().getBoolean("updater.enabled", true)) {
            MapEngineUpdater updater = new MapEngineUpdater((Plugin)this);
            Bukkit.getPluginManager().registerEvents((Listener)updater, (Plugin)this);
        }
    }

    public IPlatform<?> platform() {
        return this.platform;
    }

    public ColorPalette colorPalette() {
        return this.colorPalette;
    }

    public MapManager mapManager() {
        return this.mapManager;
    }

    public ImplMapEngineApi api() {
        return this.api;
    }

    public HoldableManager holdableManager() {
        return this.holdableManager;
    }
}

