/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core.clientside;

import de.pianoman911.mapengine.api.clientside.IFrame;
import de.pianoman911.mapengine.common.platform.PacketContainer;
import de.pianoman911.mapengine.core.MapEnginePlugin;
import de.pianoman911.mapengine.core.clientside.FilledMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class Frame
extends FilledMap
implements IFrame {
    public static final double INVISIBLE_MAP_DEPTH = 0.0078125;
    public static final double INTERACTION_OFFSET = 0.0626;
    protected final int entityId = Bukkit.getUnsafe().nextEntityId();
    protected final int interactionId = Bukkit.getUnsafe().nextEntityId();
    protected final BlockFace direction;
    protected final BlockVector pos;

    protected Frame(MapEnginePlugin plugin, BlockFace direction, BlockVector pos) {
        super(plugin);
        this.direction = direction;
        this.pos = pos;
    }

    protected PacketContainer<?> spawnPacket(BlockFace visualDirection, boolean glowing) {
        return this.plugin.platform().createMapEntitySpawnPacket(this.entityId, this.pos, visualDirection, glowing);
    }

    protected PacketContainer<?> interactionEntity() {
        Vector interactionPos;
        switch (this.direction) {
            case WEST: {
                interactionPos = new Vector(this.pos.getX() + 1.5, this.pos.getY(), this.pos.getZ() + 0.5);
                interactionPos.setX(interactionPos.getX() - 0.0626);
                break;
            }
            case EAST: {
                interactionPos = new Vector(this.pos.getX() - 0.5, this.pos.getY(), this.pos.getZ() + 0.5);
                interactionPos.setX(interactionPos.getX() + 0.0626);
                break;
            }
            case NORTH: {
                interactionPos = new Vector(this.pos.getX() + 0.5, this.pos.getY(), this.pos.getZ() + 1.5);
                interactionPos.setZ(interactionPos.getZ() - 0.0626);
                break;
            }
            case SOUTH: {
                interactionPos = new Vector(this.pos.getX() + 0.5, this.pos.getY(), this.pos.getZ() - 0.5);
                interactionPos.setZ(interactionPos.getZ() + 0.0626);
                break;
            }
            case UP: {
                interactionPos = new Vector(this.pos.getX() + 0.5, this.pos.getY() - 1.0, this.pos.getZ() + 0.5);
                interactionPos.setY(interactionPos.getY() + 0.0626);
                break;
            }
            case DOWN: {
                interactionPos = new Vector(this.pos.getX() + 0.5, this.pos.getY() + 1.0, this.pos.getZ() + 0.5);
                interactionPos.setY(interactionPos.getY() - 0.0626);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(this.direction));
            }
        }
        return this.plugin.platform().createInteractionEntitySpawnPacket(this.interactionId, interactionPos, this.direction);
    }

    protected PacketContainer<?> interactionEntitySize() {
        return this.plugin.platform().createInteractionEntityBlockSizePacket(this.interactionId);
    }

    protected PacketContainer<?> removePacket() {
        return this.plugin.platform().createRemoveEntitiesPacket((IntList)new IntArrayList(this.entityId));
    }

    protected PacketContainer<?> setIdPacket(int z, boolean invisible) {
        return this.plugin.platform().createMapSetIdPacket(this.entityId, this.mapId(z), invisible);
    }

    public BlockVector pos() {
        return this.pos;
    }

    protected PacketContainer<?> rotationPacket(float yaw, float pitch) {
        return this.plugin.platform().createTeleportPacket(this.entityId, (Vector)this.pos, yaw, pitch, false);
    }

    public PacketContainer<?> itemRotationPacket(int rotation) {
        return this.plugin.platform().createItemRotationPacket(this.entityId, rotation);
    }

    @Override
    public int frameEntityId() {
        return this.entityId;
    }

    @Override
    public int interactionEntityId() {
        return this.interactionId;
    }
}

