/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core.colors.dithering;

import de.pianoman911.mapengine.api.util.ColorBuffer;
import de.pianoman911.mapengine.api.util.FullSpacedColorBuffer;
import de.pianoman911.mapengine.core.colors.ColorPalette;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;

public class FloydSteinbergDithering {
    private static final ExecutorService EXECUTOR = new ForkJoinPool();
    private static final float FS_ERROR = 0.4375f;
    private static final float FS_ERROR2 = 0.0625f;
    private static final float FS_ERROR3 = 0.3125f;
    private static final float FS_ERROR4 = 0.1875f;

    public static ColorBuffer dither(FullSpacedColorBuffer buffer, ColorPalette palette, int threads) {
        int i;
        CompletableFuture[] futures = new CompletableFuture[threads];
        int[] src = buffer.buffer();
        int w = buffer.width();
        int h = buffer.height();
        int size = h / threads;
        for (i = 0; i < threads; ++i) {
            int finalI = i;
            futures[i] = CompletableFuture.runAsync(() -> {
                int starty = finalI * size;
                int endy = (finalI + 1) * size;
                if (finalI == threads - 1) {
                    endy = h;
                }
                for (int y = starty; y < endy; ++y) {
                    for (int x = 0; x < w; ++x) {
                        int a;
                        int index = x + y * w;
                        int rgb = src[index];
                        int oldR = rgb >> 16 & 0xFF;
                        int oldG = rgb >> 8 & 0xFF;
                        int oldB = rgb & 0xFF;
                        int mc = palette.closestColor(rgb);
                        int r = mc >> 16 & 0xFF;
                        int g = mc >> 8 & 0xFF;
                        int b = mc & 0xFF;
                        int errorR = oldR - r;
                        int errorG = oldG - g;
                        int errorB = oldB - b;
                        src[index] = mc;
                        if (x != w - 1) {
                            index = x + 1 + y * w;
                            rgb = src[index];
                            a = rgb >> 24 & 0xFF;
                            r = Math.max(0, Math.min(255, (int)((float)(rgb >> 16 & 0xFF) + (float)errorR * 0.4375f)));
                            g = Math.max(0, Math.min(255, (int)((float)(rgb >> 8 & 0xFF) + (float)errorG * 0.4375f)));
                            b = Math.max(0, Math.min(255, (int)((float)(rgb & 0xFF) + (float)errorB * 0.4375f)));
                            src[index] = a << 24 | r << 16 | g << 8 | b;
                            if (y != h - 1) {
                                index = x + 1 + (y + 1) * w;
                                rgb = src[index];
                                a = rgb >> 24 & 0xFF;
                                r = Math.max(0, Math.min(255, (int)((float)(rgb >> 16 & 0xFF) + (float)errorR * 0.0625f)));
                                g = Math.max(0, Math.min(255, (int)((float)(rgb >> 8 & 0xFF) + (float)errorG * 0.0625f)));
                                b = Math.max(0, Math.min(255, (int)((float)(rgb & 0xFF) + (float)errorB * 0.0625f)));
                                src[index] = a << 24 | r << 16 | g << 8 | b;
                            }
                        }
                        if (y == h - 1) continue;
                        index = x + (y + 1) * w;
                        rgb = src[index];
                        a = rgb >> 24 & 0xFF;
                        r = Math.max(0, Math.min(255, (int)((float)(rgb >> 16 & 0xFF) + (float)errorR * 0.3125f)));
                        g = Math.max(0, Math.min(255, (int)((float)(rgb >> 8 & 0xFF) + (float)errorG * 0.3125f)));
                        b = Math.max(0, Math.min(255, (int)((float)(rgb & 0xFF) + (float)errorB * 0.3125f)));
                        src[index] = a << 24 | r << 16 | g << 8 | b;
                        if (x == 0) continue;
                        index = x - 1 + (y + 1) * w;
                        rgb = src[index];
                        a = rgb >> 24 & 0xFF;
                        r = Math.max(0, Math.min(255, (int)((float)(rgb >> 16 & 0xFF) + (float)errorR * 0.1875f)));
                        g = Math.max(0, Math.min(255, (int)((float)(rgb >> 8 & 0xFF) + (float)errorG * 0.1875f)));
                        b = Math.max(0, Math.min(255, (int)((float)(rgb & 0xFF) + (float)errorB * 0.1875f)));
                        src[index] = a << 24 | r << 16 | g << 8 | b;
                    }
                }
            }, EXECUTOR);
        }
        CompletableFuture.allOf(futures).join();
        for (i = 1; i < threads; ++i) {
            int starty = i * size;
            for (int x = 0; x < w; ++x) {
                int index = x + starty * w;
                src[index] = palette.closestColor(src[x + (starty - 1) * w]);
            }
        }
        return new ColorBuffer(palette.colors(src), buffer.width(), buffer.height());
    }
}

