/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core.drawing;

import de.pianoman911.mapengine.api.drawing.IDrawingSpace;
import de.pianoman911.mapengine.api.drawing.ILayeredDrawingSpace;
import de.pianoman911.mapengine.api.pipeline.IPipelineContext;
import de.pianoman911.mapengine.api.util.FullSpacedColorBuffer;
import de.pianoman911.mapengine.core.drawing.DrawingSpace;
import de.pianoman911.mapengine.core.pipeline.PipelineContext;
import java.util.ArrayList;
import java.util.List;

public class LayeredDrawingSpace
implements ILayeredDrawingSpace {
    private final List<IDrawingSpace> layers = new ArrayList<IDrawingSpace>();
    private final FullSpacedColorBuffer resultBuffer;
    private final PipelineContext context;

    public LayeredDrawingSpace(FullSpacedColorBuffer initialBuffer, PipelineContext context) {
        this.resultBuffer = initialBuffer;
        this.context = context;
    }

    @Override
    public List<IDrawingSpace> layers() {
        return this.layers;
    }

    @Override
    public FullSpacedColorBuffer resultBuffer() {
        return this.resultBuffer;
    }

    @Override
    public FullSpacedColorBuffer buffer() {
        if (this.layers.isEmpty()) {
            return this.resultBuffer;
        }
        FullSpacedColorBuffer result = this.resultBuffer.copy();
        for (IDrawingSpace layer : this.layers) {
            result.buffer(layer.buffer(), 0, 0);
        }
        return result;
    }

    @Override
    public IPipelineContext ctx() {
        return this.context;
    }

    @Override
    public IDrawingSpace layer(int index) {
        return this.layers.get(index);
    }

    @Override
    public IDrawingSpace newLayer() {
        DrawingSpace drawingSpace = new DrawingSpace(this.resultBuffer.copy(), this.context);
        this.layers.add(drawingSpace);
        return drawingSpace;
    }

    @Override
    public IDrawingSpace layerOrNew(int index) {
        while (this.layers.size() <= index) {
            this.newLayer();
        }
        return this.layer(index);
    }
}

