/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core.map;

import de.pianoman911.mapengine.api.clientside.IMapDisplay;
import de.pianoman911.mapengine.api.pipeline.IPipelineStream;
import de.pianoman911.mapengine.api.util.MapTraceResult;
import de.pianoman911.mapengine.api.util.Vec2i;
import de.pianoman911.mapengine.core.MapEnginePlugin;
import de.pianoman911.mapengine.core.clientside.FrameContainer;
import de.pianoman911.mapengine.core.pipeline.MapDisplayOutput;
import de.pianoman911.mapengine.core.pipeline.Pipeline;
import de.pianoman911.mapengine.core.util.MapUtil;
import de.pianoman911.mapengine.core.util.RayTraceUtil;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockVector;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class MapManager {
    private final Set<FrameContainer> displays = new HashSet<FrameContainer>();
    private final MapEnginePlugin plugin;

    public MapManager(MapEnginePlugin plugin) {
        this.plugin = plugin;
    }

    @Nullable
    public FrameContainer display(int entityId) {
        for (FrameContainer display : this.displays()) {
            if (!display.isInteraction(entityId) && !display.hasEntity(entityId)) continue;
            return display;
        }
        return null;
    }

    @Nullable
    public FrameContainer display(BlockVector blockVector) {
        for (FrameContainer display : this.displays()) {
            if (!display.hasBlock(blockVector)) continue;
            return display;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FrameContainer> displays() {
        Set<FrameContainer> set = this.displays;
        synchronized (set) {
            return this.displays;
        }
    }

    @Deprecated
    @Nullable
    public IMapDisplay displayInView(Player player, int maxDistance) {
        MapTraceResult result = this.traceDisplayInView(player, maxDistance);
        if (result == null) {
            return null;
        }
        return result.display();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public MapTraceResult traceDisplayInView(Player player, int maxDistance) {
        Set<FrameContainer> set = this.displays;
        synchronized (set) {
            for (FrameContainer display : this.displays) {
                Pair<Vector, Vec2i> clickPos;
                RayTraceResult ray;
                Pair<Vector, BlockFace> clip;
                double distance = Math.max((double)maxDistance, display.interactDistance());
                if (distance <= 0.0 || (clip = RayTraceUtil.clipBox(player, display.interactionBox(), distance)) == null || clip.second() != display.direction() || (ray = player.rayTraceBlocks(((Vector)clip.left()).subtract(player.getEyeLocation().toVector()).length(), FluidCollisionMode.NEVER)) != null || (clickPos = MapUtil.calculateClickPosition(player, display, distance)) == null) continue;
                Location worldLoc = ((Vector)clickPos.left()).toLocation(player.getWorld());
                double distanceClick = worldLoc.distance(player.getEyeLocation());
                return new MapTraceResult((Vec2i)clickPos.right(), display, worldLoc, distanceClick);
            }
        }
        return null;
    }

    @Nullable
    public MapTraceResult traceDisplayInView(Player player) {
        return this.traceDisplayInView(player, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMapDisplay createDisplay(BlockVector a, BlockVector b, BlockFace direction, BlockFace visualDirection) {
        FrameContainer display = new FrameContainer(a, b, direction, visualDirection, this.plugin, new Pipeline(new MapDisplayOutput(this.plugin), new IPipelineStream[0]));
        Set<FrameContainer> set = this.displays;
        synchronized (set) {
            this.displays.add(display);
        }
        return display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMapDisplay createDisplay(BlockVector a, BlockVector b, BlockFace direction, BlockFace visualDirection, Pipeline pipeline) {
        FrameContainer display = new FrameContainer(a, b, direction, visualDirection, this.plugin, pipeline);
        Set<FrameContainer> set = this.displays;
        synchronized (set) {
            this.displays.add(display);
        }
        return display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisplay(FrameContainer display) {
        Set<FrameContainer> set = this.displays;
        synchronized (set) {
            this.displays.remove(display);
        }
    }
}

