/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core.pipeline;

import de.pianoman911.mapengine.api.pipeline.IPipelineContext;
import de.pianoman911.mapengine.api.pipeline.IPipelineOutput;
import de.pianoman911.mapengine.api.util.ColorBuffer;
import de.pianoman911.mapengine.api.util.FullSpacedColorBuffer;
import de.pianoman911.mapengine.common.data.MapUpdateData;
import de.pianoman911.mapengine.core.MapEnginePlugin;
import de.pianoman911.mapengine.core.cache.FrameCache;
import de.pianoman911.mapengine.core.clientside.FrameContainer;
import de.pianoman911.mapengine.core.pipeline.BaseDisplayOutput;
import org.bukkit.entity.Player;

public class MapDisplayOutput
extends BaseDisplayOutput
implements IPipelineOutput {
    public MapDisplayOutput(MapEnginePlugin plugin) {
        super(plugin);
    }

    public static ColorBuffer[] splitColorBuffer(ColorBuffer colorBuffer, int width, int height) {
        ColorBuffer[] result = new ColorBuffer[width * height];
        byte[] rawData = colorBuffer.data();
        for (int i = 0; i < result.length; ++i) {
            ColorBuffer buffer = new ColorBuffer(128, 128);
            int x = i % width;
            int y = i / width;
            for (int y1 = 0; y1 < 128; ++y1) {
                for (int x1 = 0; x1 < 128; ++x1) {
                    buffer.data()[y1 * 128 + x1] = rawData[(y * 128 + y1) * width * 128 + x * 128 + x1];
                }
            }
            result[i] = buffer;
        }
        return result;
    }

    @Override
    public void output(FullSpacedColorBuffer buffer, IPipelineContext ctx) {
        int i;
        this.removeOfflinePlayers(ctx);
        FrameContainer display = (FrameContainer)ctx.getDisplay();
        ColorBuffer buf = this.convert(buffer, ctx, display.height());
        int size = display.width() * display.height();
        ColorBuffer[] buffers = MapDisplayOutput.splitColorBuffer(buf, display.width(), display.height());
        byte[][] previousBuffers = new byte[size][];
        if (ctx.previousBuffer() != null) {
            ColorBuffer[] previous = MapDisplayOutput.splitColorBuffer(this.convert(ctx.previousBuffer(), ctx, display.height()), display.width(), display.height());
            for (i = 0; i < previous.length; ++i) {
                previousBuffers[i] = MapUpdateData.createMapUpdateData(previous[i].data(), null, 0).buffer();
            }
        }
        if (!ctx.buffering()) {
            MapUpdateData[] data = new MapUpdateData[size];
            for (i = 0; i < buffers.length; ++i) {
                data[i] = MapUpdateData.createMapUpdateData(buffers[i].data(), previousBuffers[i], 0);
            }
            for (Player receiver : ctx.receivers()) {
                display.update(receiver, data, ctx.z(), ctx.cursors(), ctx.bundling());
            }
            return;
        }
        for (Player receiver : ctx.receivers()) {
            EXECUTOR.submit(() -> {
                if (!receiver.isOnline()) {
                    return;
                }
                FrameCache cache = this.getFrameFileCache(receiver, ctx.z(), size);
                MapUpdateData[] data = new MapUpdateData[size];
                for (int i = 0; i < buffers.length; ++i) {
                    ColorBuffer currentBuffer = buffers[i];
                    data[i] = MapUpdateData.createMapUpdateData(currentBuffer.data(), cache.read(i), 0);
                    cache.write(currentBuffer.data(), i);
                }
                display.update(receiver, data, ctx.z(), ctx.cursors(), ctx.bundling());
            });
        }
    }
}

