/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core.pipeline;

import de.pianoman911.mapengine.api.MapEngineApi;
import de.pianoman911.mapengine.api.clientside.IDisplay;
import de.pianoman911.mapengine.api.pipeline.IPipelineContext;
import de.pianoman911.mapengine.api.util.Converter;
import de.pianoman911.mapengine.api.util.FullSpacedColorBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCursorCollection;

public class PipelineContext
implements IPipelineContext {
    private final Set<Player> receivers = Collections.newSetFromMap(new WeakHashMap());
    private final MapEngineApi api;
    private final IDisplay display;
    private final MapCursorCollection cursors = new MapCursorCollection();
    private boolean buffering = false;
    private boolean bundling = false;
    private int z = 0;
    private Converter converter = Converter.DIRECT;
    private FullSpacedColorBuffer previousBuffer;

    public PipelineContext(MapEngineApi api, IDisplay display) {
        this.api = api;
        this.display = display;
    }

    @Override
    public Set<Player> receivers() {
        return this.receivers;
    }

    @Override
    public void receivers(Collection<? extends Player> receivers) {
        this.receivers.clear();
        this.receivers.addAll(receivers);
    }

    @Override
    public void addReceiver(Player ... players) {
        Collections.addAll(this.receivers, players);
    }

    @Override
    public void removeReceiver(Player ... players) {
        for (Player player : players) {
            this.receivers.remove(player);
        }
    }

    @Override
    public boolean isReceiver(Player player) {
        return this.receivers.contains(player);
    }

    @Override
    public void clearReceivers() {
        this.receivers.clear();
    }

    @Override
    public IDisplay getDisplay() {
        return this.display;
    }

    @Override
    public boolean buffering() {
        return this.buffering;
    }

    @Override
    public void buffering(boolean buffering) {
        this.buffering = buffering;
    }

    @Override
    public boolean bundling() {
        return this.bundling;
    }

    @Override
    public void bundling(boolean bundling) {
        this.bundling = bundling;
    }

    @Override
    public int z() {
        return this.z;
    }

    @Override
    public void z(int z) {
        this.z = z;
    }

    @Override
    public MapCursorCollection cursors() {
        return this.cursors;
    }

    @Override
    public Converter converter() {
        return this.converter;
    }

    @Override
    public FullSpacedColorBuffer previousBuffer() {
        return this.previousBuffer;
    }

    @Override
    public void previousBuffer(FullSpacedColorBuffer previousBuffer) {
        this.previousBuffer = previousBuffer;
    }

    @Override
    public MapEngineApi mapEngineApi() {
        return this.api;
    }

    @Override
    public void converter(Converter converter) {
        if (converter == null) {
            throw new IllegalArgumentException("Converter cannot be null");
        }
        this.converter = converter;
    }
}

