/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.mapengine.core.util;

import de.pianoman911.mapengine.api.util.Vec2i;
import de.pianoman911.mapengine.core.clientside.FrameContainer;
import de.pianoman911.mapengine.core.util.RayTraceUtil;
import it.unimi.dsi.fastutil.Pair;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public final class MapUtil {
    public static final int MAP_WIDTH = 128;
    public static final int MAP_HEIGHT = 128;
    public static final int MAP_PIXEL_COUNT = 16384;

    private MapUtil() {
    }

    public static Vector itemFrameOffset(Vector vector, BlockFace direction) {
        vector = vector.clone();
        switch (direction) {
            case NORTH: {
                vector.setZ(vector.getZ() - 1.0);
                break;
            }
            case SOUTH: {
                vector.setZ(vector.getZ() + 1.0);
                break;
            }
            case WEST: {
                vector.setX(vector.getX() - 1.0);
                break;
            }
            case EAST: {
                vector.setX(vector.getX() + 1.0);
                break;
            }
            case UP: {
                vector.setY(vector.getY() + 1.0);
                break;
            }
            case DOWN: {
                vector.setY(vector.getY() - 1.0);
            }
        }
        return vector;
    }

    public static BlockVector toRealBlockVector(Vector vector) {
        return new BlockVector(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    public static <T extends Vector> T absVector(T vector) {
        vector.setX(Math.abs(vector.getX()));
        vector.setY(Math.abs(vector.getY()));
        vector.setZ(Math.abs(vector.getZ()));
        return vector;
    }

    @Nullable
    public static Pair<Vector, Vec2i> calculateClickPosition(Player player, FrameContainer map, double maxDistance) {
        int x;
        Pair<Vector, BlockFace> clipped = RayTraceUtil.clipBox(player, map.interactionBox(), maxDistance);
        if (clipped == null || clipped.second() != map.direction()) {
            return null;
        }
        Vector clickedPos = ((Vector)clipped.left()).clone().subtract(map.interactionBox().getCenter().setY(map.box().getMinY()));
        double posX = clickedPos.getX();
        double posY = clickedPos.getY();
        double posZ = clickedPos.getZ();
        return Pair.of((Object)((Vector)clipped.left()), (Object)new Vec2i(x, switch (map.direction()) {
            case BlockFace.EAST -> {
                x = (int)(((double)map.width() - (posZ + (double)map.width() / 2.0)) * 128.0);
                yield (int)(((double)map.height() - posY) * 128.0);
            }
            case BlockFace.WEST -> {
                x = (int)((posZ + (double)map.width() / 2.0) * 128.0);
                yield (int)(((double)map.height() - posY) * 128.0);
            }
            case BlockFace.SOUTH -> {
                x = (int)((posX + (double)map.width() / 2.0) * 128.0);
                yield (int)(((double)map.height() - posY) * 128.0);
            }
            case BlockFace.NORTH -> {
                x = (int)(((double)map.width() - (posX + (double)map.width() / 2.0)) * 128.0);
                yield (int)(((double)map.height() - posY) * 128.0);
            }
            case BlockFace.UP -> {
                x = (int)((posX + (double)map.width() / 2.0) * 128.0);
                yield (int)((posZ + (double)map.height() / 2.0) * 128.0);
            }
            case BlockFace.DOWN -> {
                x = (int)((posX + (double)map.width() / 2.0) * 128.0);
                yield (int)(((double)map.height() - (posZ + (double)map.height() / 2.0)) * 128.0);
            }
            default -> throw new UnsupportedOperationException("Unsupported direction: " + String.valueOf(map.direction()));
        }));
    }
}

