/*
 * Decompiled with CFR 0.152.
 */
package net.derd;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.derd.init.DerdModModAttributes;
import net.derd.init.DerdModModBlockEntities;
import net.derd.init.DerdModModBlocks;
import net.derd.init.DerdModModEnchantments;
import net.derd.init.DerdModModEntities;
import net.derd.init.DerdModModFluidTypes;
import net.derd.init.DerdModModFluids;
import net.derd.init.DerdModModItems;
import net.derd.init.DerdModModMenus;
import net.derd.init.DerdModModMobEffects;
import net.derd.init.DerdModModPaintings;
import net.derd.init.DerdModModParticleTypes;
import net.derd.init.DerdModModPotions;
import net.derd.init.DerdModModSounds;
import net.derd.init.DerdModModTabs;
import net.derd.init.DerdModModVillagerProfessions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="derd_mod")
public class DerdModMod {
    public static final Logger LOGGER = LogManager.getLogger(DerdModMod.class);
    public static final String MODID = "derd_mod";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("derd_mod", "derd_mod"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public DerdModMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DerdModModSounds.REGISTRY.register(bus);
        DerdModModBlocks.REGISTRY.register(bus);
        DerdModModBlockEntities.REGISTRY.register(bus);
        DerdModModItems.REGISTRY.register(bus);
        DerdModModEntities.REGISTRY.register(bus);
        DerdModModEnchantments.REGISTRY.register(bus);
        DerdModModTabs.REGISTRY.register(bus);
        DerdModModMobEffects.REGISTRY.register(bus);
        DerdModModPotions.REGISTRY.register(bus);
        DerdModModPaintings.REGISTRY.register(bus);
        DerdModModParticleTypes.REGISTRY.register(bus);
        DerdModModVillagerProfessions.PROFESSIONS.register(bus);
        DerdModModMenus.REGISTRY.register(bus);
        DerdModModFluids.REGISTRY.register(bus);
        DerdModModFluidTypes.REGISTRY.register(bus);
        DerdModModAttributes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

