/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.modules;

import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.utils.ReflectionUtils;

public class EntityLimiterModule
extends AbstractModule
implements Listener {
    private final EnumSet<CreatureSpawnEvent.SpawnReason> reasons = EnumSet.noneOf(CreatureSpawnEvent.SpawnReason.class);
    private final EnumSet<EntityType> whitelist = EnumSet.noneOf(EntityType.class);
    private int locks;
    private BukkitTask alerts_task;
    private BukkitTask overflow_task;
    private boolean alerts;
    private boolean ignore_models;
    private int creatures;
    private int items;
    private int vehicles;
    private int projectiles;
    private int others;
    private boolean overflow_enabled;
    private int overflow_interval;
    private double overflow_multiplier;
    private boolean overflow_creatures;
    private boolean overflow_items;
    private boolean overflow_vehicles;
    private boolean overflow_projectiles;
    private boolean overflow_others;
    private boolean overflow_named;

    public EntityLimiterModule(LagFixer plugin, ModuleManager manager) {
        super(plugin, manager, AbstractModule.Impact.HIGH, "EntityLimiter", new String[]{"Restricts the number of entities per chunk.", "Essential for survival servers with expansive animal farms.", "Prevents excessive entity accumulation and associated performance issues.", "Maintains stable performance levels even in environments with high entity density."}, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZWRjMzZjOWNiNTBhNTI3YWE1NTYwN2EwZGY3MTg1YWQyMGFhYmFhOTAzZThkOWFiZmM3ODI2MDcwNTU0MGRlZiJ9fX0=");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSpawn(CreatureSpawnEvent e) {
        if (this.creatures < 1 || !this.canContinue(e.getLocation().getWorld()) || !this.reasons.contains(e.getSpawnReason()) || this.whitelist.contains(e.getEntityType())) {
            return;
        }
        if (this.countEntities(e.getLocation().getChunk(), ent -> ent instanceof Mob) >= (long)this.creatures && (this.ignore_models || HookManager.getInstance().getModel().hasModel((Entity)e.getEntity()))) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        if (this.items < 1 || !this.canContinue(e.getItemDrop().getWorld()) || this.whitelist.contains(e.getItemDrop().getType())) {
            return;
        }
        if (this.countEntities(e.getItemDrop().getLocation().getChunk(), ent -> ent instanceof Item) >= (long)this.items) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onVehicle(VehicleCreateEvent e) {
        if (this.vehicles < 1 || !this.canContinue(e.getVehicle().getWorld()) || this.whitelist.contains(e.getVehicle().getType())) {
            return;
        }
        if (this.countEntities(e.getVehicle().getLocation().getChunk(), ent -> ent instanceof Vehicle) >= (long)this.vehicles) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onSpawn(EntitySpawnEvent e) {
        if (this.others < 1 || !this.canContinue(e.getEntity().getWorld()) || this.whitelist.contains(e.getEntityType())) {
            return;
        }
        if (this.countEntities(e.getLocation().getChunk(), ent -> !(ent instanceof Mob) && !(ent instanceof Item) && !(ent instanceof Vehicle) && !(ent instanceof Projectile) && !(ent instanceof Player)) >= (long)this.others) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onLaunch(ProjectileLaunchEvent e) {
        if (this.projectiles < 1 || !this.canContinue(e.getLocation().getWorld()) || this.whitelist.contains(e.getEntityType())) {
            return;
        }
        if (this.countEntities(e.getLocation().getChunk(), ent -> ent instanceof Projectile) >= (long)this.projectiles) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    public long countEntities(Chunk c, Predicate<Entity> predicate) {
        if (!c.isLoaded()) {
            return 0L;
        }
        Entity[] entities = c.getEntities();
        int count = 0;
        for (Entity entity : entities) {
            if (!predicate.test(entity) || this.whitelist.contains(entity.getType())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void load() {
        if (this.alerts) {
            this.alerts_task = SupportManager.getInstance().getFork().runTimer(true, () -> {
                if (this.locks > 75) {
                    this.getPlugin().getLogger().info("Entity limiter cancelled " + this.locks + " events!");
                    this.locks = 0;
                }
            }, 2L, 2L, TimeUnit.SECONDS);
        }
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
        if (this.overflow_enabled) {
            int limit_creatures = (int)((double)this.creatures * this.overflow_multiplier);
            int limit_items = (int)((double)this.items * this.overflow_multiplier);
            int limit_vehicles = (int)((double)this.vehicles * this.overflow_multiplier);
            int limit_projectiles = (int)((double)this.projectiles * this.overflow_multiplier);
            int limit_others = (int)((double)this.others * this.overflow_multiplier);
            boolean checkCreatures = this.overflow_creatures;
            boolean checkItems = this.overflow_items;
            boolean checkVehicles = this.overflow_vehicles;
            boolean checkProjectiles = this.overflow_projectiles;
            boolean checkOthers = this.overflow_others;
            this.overflow_task = SupportManager.getInstance().getFork().runTimer(false, () -> this.getAllowedWorlds().forEach(w -> {
                Chunk[] chunks;
                for (Chunk chunk : chunks = w.getLoadedChunks()) {
                    Entity[] entities = chunk.getEntities();
                    if (entities.length == 0) continue;
                    int creatures = 0;
                    int items = 0;
                    int vehicles = 0;
                    int projectiles = 0;
                    int others = 0;
                    for (Entity entity : entities) {
                        if (this.whitelist.contains(entity.getType()) || !this.overflow_named && entity.getCustomName() != null || !this.ignore_models && HookManager.getInstance().getModel().hasModel(entity)) continue;
                        boolean removed = false;
                        if (entity instanceof Mob) {
                            if (creatures < limit_creatures) {
                                ++creatures;
                            } else if (checkCreatures) {
                                removed = true;
                            }
                        } else if (entity instanceof Item) {
                            if (items < limit_items) {
                                ++items;
                            } else if (checkItems) {
                                removed = true;
                            }
                        } else if (entity instanceof Vehicle) {
                            if (vehicles < limit_vehicles) {
                                ++vehicles;
                            } else if (checkVehicles) {
                                removed = true;
                            }
                        } else if (entity instanceof Projectile) {
                            if (projectiles < limit_projectiles) {
                                ++projectiles;
                            } else if (checkProjectiles) {
                                removed = true;
                            }
                        } else if (!(entity instanceof Player)) {
                            if (others < limit_others) {
                                ++others;
                            } else if (checkOthers) {
                                removed = true;
                            }
                        }
                        if (!removed) continue;
                        entity.remove();
                        ++this.locks;
                    }
                }
            }), this.overflow_interval, this.overflow_interval, TimeUnit.SECONDS);
        }
    }

    @Override
    public boolean loadConfig() {
        this.alerts = this.getSection().getBoolean("alerts");
        this.ignore_models = HookManager.getInstance().noneModels() || this.getSection().getBoolean("ignore_models");
        this.creatures = this.getSection().getInt("creatures");
        this.items = this.getSection().getInt("items");
        this.vehicles = this.getSection().getInt("vehicles");
        this.projectiles = this.getSection().getInt("projectiles");
        this.others = this.getSection().getInt("others");
        ReflectionUtils.convertEnums(CreatureSpawnEvent.SpawnReason.class, this.reasons, this.getSection().getStringList("reasons"));
        ReflectionUtils.convertEnums(EntityType.class, this.whitelist, this.getSection().getStringList("whitelist"));
        this.overflow_interval = this.getSection().getInt("overflow_purge.interval");
        boolean bl = this.overflow_enabled = this.overflow_interval > 0 && this.getSection().getBoolean("overflow_purge.enabled");
        if (this.overflow_enabled) {
            this.overflow_multiplier = this.getSection().getDouble("overflow_purge.limit_multiplier");
            this.overflow_creatures = this.creatures > 0 && this.getSection().getBoolean("overflow_purge.types.creatures");
            this.overflow_items = this.items > 0 && this.getSection().getBoolean("overflow_purge.types.items");
            this.overflow_vehicles = this.vehicles > 0 && this.getSection().getBoolean("overflow_purge.types.vehicles");
            this.overflow_projectiles = this.projectiles > 0 && this.getSection().getBoolean("overflow_purge.types.projectiles");
            this.overflow_others = this.others > 0 && this.getSection().getBoolean("overflow_purge.types.others");
            this.overflow_named = this.getSection().getBoolean("overflow_purge.types.named");
        }
        return true;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.alerts_task != null) {
            this.alerts_task.cancel();
        }
        if (this.overflow_task != null) {
            this.overflow_task.cancel();
        }
    }
}

