/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.objects;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.Language;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.Component;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.minimessage.MiniMessage;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.menu.ConfigMenu;
import xyz.lychee.lagfixer.utils.ItemBuilder;

public abstract class AbstractModule {
    private final LagFixer plugin;
    private final ModuleManager manager;
    private final HashSet<String> worlds = new HashSet();
    private final Impact impact;
    private final String name;
    private final String[] description;
    private final ItemStack baseSkull;
    private final YamlConfiguration config;
    private ConfigurationSection section;
    private final ConfigMenu menu;
    private boolean loaded = false;
    private Language language;
    private int canContinue;

    public AbstractModule(LagFixer plugin, ModuleManager manager, Impact impact, String name, String[] description, String texture) {
        this.plugin = plugin;
        this.manager = manager;
        this.impact = impact;
        this.name = name;
        this.description = description;
        this.baseSkull = ItemBuilder.createSkull(texture).build();
        this.config = new YamlConfiguration();
        this.language = new Language(this);
        try {
            this.loadConfigSection();
        }
        catch (Exception ex) {
            this.plugin.printError(ex);
        }
        ConfigurationSection defSection = this.section.getDefaultSection() == null ? this.section : this.section.getDefaultSection();
        long valueCount = defSection.getValues(true).entrySet().stream().filter(e -> !(e.getValue() instanceof ConfigurationSection)).count();
        int size = (int)Math.max(9L, Math.min(45L, (valueCount + 8L) / 9L * 9L)) + 9;
        this.menu = new ConfigMenu(this.plugin, defSection, size, this);
    }

    public boolean loadAllConfig() throws Exception {
        this.loadConfigSection();
        this.language.loadMessages();
        return this.loadConfig();
    }

    public void loadConfigSection() throws Exception {
        this.loadConfigFile();
        this.section = this.config.getConfigurationSection(this.name + ".values");
        this.worlds.clear();
        this.worlds.addAll(this.config.getStringList(this.name + ".worlds"));
        this.canContinue = this.worlds.isEmpty() ? -1 : (this.worlds.contains("*") ? 1 : 0);
    }

    public void loadConfigFile() throws Exception {
        ConfigurationSection section;
        String sectionPath;
        FileConfiguration mainCfg;
        YamlConfiguration defaultConfig;
        String resourcePath = "modules/" + this.name + ".yml";
        InputStream defStream = this.plugin.getResource(resourcePath);
        if (defStream == null) {
            this.plugin.getLogger().warning("Couldn't find config file " + this.name + ".yml in resources");
            return;
        }
        try (InputStreamReader r = new InputStreamReader(defStream, StandardCharsets.UTF_8);){
            defaultConfig = YamlConfiguration.loadConfiguration((Reader)r);
        }
        File configFile = new File(this.plugin.getDataFolder(), resourcePath);
        if (configFile.exists()) {
            this.config.load(configFile);
            this.config.setDefaults((Configuration)defaultConfig);
            this.config.options().copyDefaults(true);
            this.config.save(configFile);
            return;
        }
        File parent = configFile.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            this.plugin.getLogger().warning("Could not create directory: " + parent);
        }
        if ((mainCfg = this.plugin.getConfig()).isConfigurationSection(sectionPath = "modules." + this.name) && (section = mainCfg.getConfigurationSection(sectionPath)) != null) {
            this.config.set(this.name, (Object)section);
            this.config.setDefaults((Configuration)defaultConfig);
            this.config.options().copyDefaults(true);
            this.config.save(configFile);
            mainCfg.set(sectionPath, (Object)("Configuration has been moved to \"LagFixer/modules/" + this.name + ".yml\""));
            return;
        }
        this.plugin.saveResource(resourcePath, false);
        this.config.load(configFile);
        this.config.setDefaults((Configuration)defaultConfig);
        this.config.options().copyDefaults(true);
        this.config.save(configFile);
    }

    public boolean canContinue(World w) {
        return this.canContinue == 0 ? this.worlds.contains(w.getName()) : this.canContinue == 1;
    }

    public Stream<World> getAllowedWorldsStream() {
        return Bukkit.getWorlds().stream().filter(this::canContinue);
    }

    public Set<World> getAllowedWorlds() {
        HashSet<World> set = new HashSet<World>();
        for (World world : Bukkit.getWorlds()) {
            if (!this.canContinue(world)) continue;
            set.add(world);
        }
        return Collections.unmodifiableSet(set);
    }

    public abstract void load() throws Exception;

    public abstract boolean loadConfig() throws Exception;

    public abstract void disable() throws Exception;

    public LagFixer getPlugin() {
        return this.plugin;
    }

    public ModuleManager getManager() {
        return this.manager;
    }

    public HashSet<String> getWorlds() {
        return this.worlds;
    }

    public Impact getImpact() {
        return this.impact;
    }

    public String getName() {
        return this.name;
    }

    public String[] getDescription() {
        return this.description;
    }

    public ItemStack getBaseSkull() {
        return this.baseSkull;
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public ConfigurationSection getSection() {
        return this.section;
    }

    public ConfigMenu getMenu() {
        return this.menu;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Language getLanguage() {
        return this.language;
    }

    public int getCanContinue() {
        return this.canContinue;
    }

    public void setSection(ConfigurationSection section) {
        this.section = section;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public void setCanContinue(int canContinue) {
        this.canContinue = canContinue;
    }

    public static enum Impact {
        VERY_HIGH("<bold><gradient:#069e00:#0aff00>VERY HIGH</gradient>"),
        HIGH("<bold><gradient:#1fab1a:#3dff2b>HIGH</gradient>"),
        MEDIUM("<bold><gradient:#a6ab1a:#ffe32b>MEDIUM</gradient>"),
        LOW("<bold><gradient:#ab591a:#ff6b2b>LOW</gradient>"),
        VERY_LOW("<bold><gradient:#ab1e1a:#ff322b>VERY LOW</gradient>"),
        VISUAL_ONLY("<bold><gradient:#1a5eab:#26baff>VISUAL ONLY</gradient>");

        private final Component component;

        private Impact(String text) {
            this.component = MiniMessage.miniMessage().deserialize(text);
        }

        public Component getComponent() {
            return this.component;
        }
    }
}

