/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.utils;

import java.util.Arrays;
import java.util.Random;

public class FastRandom
extends Random
implements Cloneable {
    private static final long serialVersionUID = 1L;
    protected long seed;

    public FastRandom() {
        this(System.nanoTime());
    }

    public FastRandom(long seed) {
        this.seed = seed;
    }

    public synchronized long getSeed() {
        return this.seed;
    }

    @Override
    public synchronized void setSeed(long seed) {
        this.seed = seed;
        super.setSeed(seed);
    }

    public synchronized void setSeed(int[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("Array length must be greater than zero");
        }
        this.setSeed(Arrays.hashCode(array));
    }

    public FastRandom clone() throws CloneNotSupportedException {
        return (FastRandom)super.clone();
    }

    @Override
    protected int next(int nbits) {
        long x = this.seed;
        x ^= x << 21;
        x ^= x >>> 35;
        x ^= x << 4;
        this.seed = x;
        return (int)(x &= (1L << nbits) - 1L);
    }
}

