/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.objects.AbstractFork;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.objects.AbstractMonitor;
import xyz.lychee.lagfixer.objects.AbstractSupportNms;
import xyz.lychee.lagfixer.support.PaperSupport;
import xyz.lychee.lagfixer.support.SpigotSupport;

public class SupportManager
extends AbstractManager
implements Listener {
    private static SupportManager instance;
    private final Map<String, String> versions;
    private ScheduledExecutorService executor;
    private BukkitTask task = null;
    private String nmsVersion = null;
    private AbstractFork fork = null;
    private AbstractSupportNms nms = null;
    private AbstractMonitor monitor = new StandardMonitor();
    private int entities = 0;
    private int creatures = 0;
    private int items = 0;
    private int projectiles = 0;
    private int vehicles = 0;

    public SupportManager(LagFixer plugin) {
        super(plugin);
        instance = this;
        this.versions = new HashMap<String, String>();
        this.versions.put("1.20.5", "v1_20_R4");
        this.versions.put("1.20.6", "v1_20_R4");
        this.versions.put("1.21", "v1_21_R1");
        this.versions.put("1.21.1", "v1_21_R1");
        this.versions.put("1.21.2", "v1_21_R2");
        this.versions.put("1.21.3", "v1_21_R2");
        this.versions.put("1.21.4", "v1_21_R3");
        this.versions.put("1.21.5", "v1_21_R4");
        this.versions.put("1.21.6", "v1_21_R5");
        this.versions.put("1.21.7", "v1_21_R5");
        this.versions.put("1.21.8", "v1_21_R5");
        this.versions.put("1.21.9", "v1_21_R6");
        this.versions.put("1.21.10", "v1_21_R6");
        this.versions.put("1.21.11", "v1_21_R7");
    }

    @Override
    public void load() {
        FileConfiguration cfg = this.getPlugin().getConfig();
        int threads = cfg.getInt("main.threads", 1);
        this.executor = threads > 1 ? Executors.newScheduledThreadPool(threads) : Executors.newSingleThreadScheduledExecutor();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
        Stream.of(new SpigotSupport((Plugin)this.getPlugin()), new PaperSupport((Plugin)this.getPlugin())).filter(AbstractFork::isSupported).max(Comparator.comparingInt(AbstractFork::getPriority)).ifPresent(fork -> {
            this.fork = fork;
            this.getPlugin().getLogger().info(" &8\u2022 &rLoaded fork support ~ " + this.fork.getClass().getCanonicalName());
        });
        Server server = Bukkit.getServer();
        String version = server.getBukkitVersion().split("-")[0];
        if (this.versions.containsKey(version)) {
            this.nmsVersion = this.versions.get(version);
        } else {
            String[] parts = server.getClass().getPackage().getName().split("\\.");
            String lastPart = parts[parts.length - 1];
            if (lastPart.matches("v\\d+_\\d+_R\\d+")) {
                this.nmsVersion = lastPart;
            } else {
                this.getPlugin().getLogger().info("   &cPlugin is outdated, update from:");
                this.getPlugin().getLogger().info("   &chttps://modrinth.com/plugin/lagfixer");
                this.nms = new DeprecatedBukkitSupport((Plugin)this.getPlugin());
                return;
            }
        }
        try {
            Class<?> clazz = Class.forName("xyz.lychee.lagfixer.nms." + this.nmsVersion + ".SupportNms");
            Constructor<?> constructor = clazz.getConstructor(Plugin.class);
            this.nms = (AbstractSupportNms)constructor.newInstance(new Object[]{this.getPlugin()});
            Bukkit.getPluginManager().registerEvents((Listener)this.nms, (Plugin)this.getPlugin());
            this.getPlugin().getLogger().info(" &8\u2022 &rLoaded nms support ~ " + this.nms.getClass().getCanonicalName());
        }
        catch (Throwable ex) {
            this.getPlugin().getLogger().info("   &cOptimal support not found, the plugin will use reflection methods!");
            this.getPlugin().getLogger().info("   &7Supported versions: &e1.16.5, 1.17.1, 1.18.2, 1.19.4, 1.20 - 1.21.10");
            this.nms = new DeprecatedBukkitSupport((Plugin)this.getPlugin());
            this.getPlugin().printError(ex);
        }
        this.monitor.start(cfg.getInt("main.monitor_interval"));
        this.task = this.getFork().runTimer(false, () -> {
            int entities = 0;
            int creatures = 0;
            int items = 0;
            int projectiles = 0;
            int vehicles = 0;
            for (World world : Bukkit.getWorlds()) {
                List list = world.getEntities();
                entities += list.size();
                for (Entity entity : list) {
                    if (entity instanceof Mob) {
                        ++creatures;
                        continue;
                    }
                    if (entity instanceof Vehicle) {
                        ++vehicles;
                        continue;
                    }
                    if (entity instanceof Item) {
                        ++items;
                        continue;
                    }
                    if (!(entity instanceof Projectile)) continue;
                    ++projectiles;
                }
            }
            this.entities = entities;
            this.creatures = creatures;
            this.items = items;
            this.projectiles = projectiles;
            this.vehicles = vehicles;
        }, 15L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
        if (this.executor != null) {
            this.executor.close();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public Map<String, String> getVersions() {
        return this.versions;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public BukkitTask getTask() {
        return this.task;
    }

    public String getNmsVersion() {
        return this.nmsVersion;
    }

    public AbstractFork getFork() {
        return this.fork;
    }

    public AbstractSupportNms getNms() {
        return this.nms;
    }

    public AbstractMonitor getMonitor() {
        return this.monitor;
    }

    public int getEntities() {
        return this.entities;
    }

    public int getCreatures() {
        return this.creatures;
    }

    public int getItems() {
        return this.items;
    }

    public int getProjectiles() {
        return this.projectiles;
    }

    public int getVehicles() {
        return this.vehicles;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public void setTask(BukkitTask task) {
        this.task = task;
    }

    public void setNmsVersion(String nmsVersion) {
        this.nmsVersion = nmsVersion;
    }

    public void setFork(AbstractFork fork) {
        this.fork = fork;
    }

    public void setNms(AbstractSupportNms nms) {
        this.nms = nms;
    }

    public void setMonitor(AbstractMonitor monitor) {
        this.monitor = monitor;
    }

    public void setEntities(int entities) {
        this.entities = entities;
    }

    public void setCreatures(int creatures) {
        this.creatures = creatures;
    }

    public void setItems(int items) {
        this.items = items;
    }

    public void setProjectiles(int projectiles) {
        this.projectiles = projectiles;
    }

    public void setVehicles(int vehicles) {
        this.vehicles = vehicles;
    }

    public static SupportManager getInstance() {
        return instance;
    }

    class StandardMonitor
    extends AbstractMonitor {
        private final OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);

        StandardMonitor() {
        }

        @Override
        protected double cpuProcess() {
            return this.osBean.getProcessCpuLoad() * 100.0;
        }

        @Override
        protected double cpuSystem() {
            return this.osBean.getSystemCpuLoad() * 100.0;
        }

        @Override
        protected double tps() {
            return SupportManager.this.getNms().getTps();
        }

        @Override
        protected double mspt() {
            return SupportManager.this.getFork().getMspt();
        }
    }

    static class DeprecatedBukkitSupport
    extends AbstractSupportNms {
        private Method getServerMethod;
        private Field recentTpsField;
        private Method setProfileMethod;
        private Field profileField;
        private Method getHandleMethod;
        private Field pingField;

        public DeprecatedBukkitSupport(Plugin plugin) {
            super(plugin);
        }

        private void initializeReflection() {
            try {
                Server craftServer = Bukkit.getServer();
                this.getServerMethod = craftServer.getClass().getMethod("getServer", new Class[0]);
                Object minecraftServer = this.getServerMethod.invoke((Object)craftServer, new Object[0]);
                this.recentTpsField = minecraftServer.getClass().getField("recentTps");
            }
            catch (Exception craftServer) {
                // empty catch block
            }
            ItemMeta tempMeta = Bukkit.getItemFactory().getItemMeta(Material.PLAYER_HEAD);
            if (tempMeta != null) {
                try {
                    this.setProfileMethod = tempMeta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                    this.setProfileMethod.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                try {
                    this.profileField = tempMeta.getClass().getDeclaredField("profile");
                    this.profileField.setAccessible(true);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }

        @Override
        public double getTps() {
            this.initializeReflection();
            if (this.getServerMethod == null || this.recentTpsField == null) {
                return -1.0;
            }
            int index = 2;
            try {
                Server craftServer = Bukkit.getServer();
                Object minecraftServer = this.getServerMethod.invoke((Object)craftServer, new Object[0]);
                if (minecraftServer == null) {
                    return -1.0;
                }
                double[] tps = (double[])this.recentTpsField.get(minecraftServer);
                if (index >= tps.length) {
                    index = 0;
                }
                return Math.min(20.0, tps[index]);
            }
            catch (Exception e) {
                return -1.0;
            }
        }

        @Override
        public ItemStack createSkull(String base64) {
            ItemStack is = new ItemStack(Material.PLAYER_HEAD);
            ItemMeta meta = is.getItemMeta();
            if (meta == null) {
                return is;
            }
            this.initializeReflection();
            UUID uuid = UUID.randomUUID();
            GameProfile profile = new GameProfile(uuid, uuid.toString().substring(0, 8));
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", base64));
            if (this.setProfileMethod != null) {
                try {
                    this.setProfileMethod.invoke((Object)meta, profile);
                    is.setItemMeta(meta);
                    return is;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.profileField != null) {
                try {
                    this.profileField.set(meta, profile);
                    is.setItemMeta(meta);
                    return is;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return is;
        }

        @Override
        public int getTileEntitiesCount(Chunk chunk) {
            return 0;
        }

        @Override
        public int getPlayerPing(Player player) {
            this.initializeReflection();
            if (this.getHandleMethod == null || this.pingField == null) {
                try {
                    this.getHandleMethod = player.getClass().getMethod("getHandle", new Class[0]);
                    Object entityPlayer = this.getHandleMethod.invoke((Object)player, new Object[0]);
                    this.pingField = entityPlayer.getClass().getField("ping");
                    this.pingField.setAccessible(true);
                }
                catch (Exception e) {
                    return -1;
                }
            }
            try {
                Object handle = this.getHandleMethod.invoke((Object)player, new Object[0]);
                return this.pingField.getInt(handle);
            }
            catch (Exception e) {
                return -1;
            }
        }
    }
}

