/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_18_R2;

import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.modules.MobAiReducerModule;

public class MobAiReducer
extends MobAiReducerModule.NMS
implements Listener {
    private final Map<EntityCreature, Boolean> optimizedMobs = new MapMaker().weakKeys().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends net.minecraft.world.entity.Entity>, PathfinderTargetCondition> temptTargeting = new HashMap<Class<? extends net.minecraft.world.entity.Entity>, PathfinderTargetCondition>();
    private final PathfinderTargetCondition breedTargeting = PathfinderTargetCondition.b().d();

    public MobAiReducer(MobAiReducerModule module) {
        super(module);
    }

    @Override
    public void load() {
        this.breedTargeting.a(this.getModule().getBreedRange());
        this.register(EntityCow.class, Items.ni);
        this.register(EntityMushroomCow.class, Items.ni);
        this.register(EntitySheep.class, Items.ni);
        this.register(EntityPig.class, Items.rl, Items.rm, Items.sn);
        this.register(EntityChicken.class, Items.nh, Items.pu, Items.pt, Items.so);
        this.register(EntityRabbit.class, Items.rl, Items.rq, Items.cr);
        this.register(EntityHorse.class, Items.mf, Items.nM, Items.rq, Items.oW, Items.gi, Items.ni);
        this.register(EntityHorseDonkey.class, Items.mf, Items.nM, Items.rq, Items.oW, Items.gi, Items.ni);
        this.register(EntityLlama.class, Items.gi, Items.ni);
        this.register(EntityParrot.class, Items.nh, Items.pu, Items.pt, Items.so);
        this.register(EntityOcelot.class, Items.ov, Items.ow);
        this.register(EntityCat.class, Items.ov, Items.ow);
        this.register(EntityPanda.class, Items.cV, Items.oX);
        this.register(EntityFox.class, Items.to, Items.tp);
        this.register(EntityTurtle.class, Items.bZ);
        this.register(EntityBee.class, Items.cs, Items.cr, Items.ct, Items.cu, Items.cv, Items.cw, Items.cx, Items.cy, Items.cz, Items.cA, Items.cB, Items.cC, Items.gE);
        this.register(EntityStrider.class, Items.cI);
        this.register(Goat.class, Items.ni);
        this.register(Axolotl.class, Items.og);
    }

    private void register(Class<? extends net.minecraft.world.entity.Entity> clazz, Item ... items) {
        HashSet itemSet = Sets.newHashSet((Object[])items);
        this.temptTargeting.computeIfAbsent(clazz, k -> PathfinderTargetCondition.b().d()).a(this.getModule().getTemptRange()).a(entity -> itemSet.contains(entity.es().c()) || this.getModule().isTemptTriggerBothHands() && itemSet.contains(entity.et().c()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimize(Entity ent, boolean init) {
        Set goals;
        if (!(ent instanceof CraftCreature)) {
            return;
        }
        EntityCreature handle = ((CraftCreature)ent).getHandle();
        if (this.optimizedMobs.containsKey(handle)) {
            return;
        }
        MobAiReducerModule module = this.getModule();
        boolean keepDedicated = module.isKeep_dedicated();
        boolean aiListMode = module.isAi_list_mode();
        HashSet<String> aiList = module.getAi_list();
        handle.collides = module.isCollides();
        handle.d(module.isSilent());
        this.optimizedMobs.put(handle, Boolean.TRUE);
        boolean isAnimal = handle instanceof EntityAnimal;
        Class<?> handleClass = handle.getClass();
        PathfinderTargetCondition temptTargeting = module.isTemptEnabled() ? this.temptTargeting.get(handleClass) : null;
        Set set = goals = handle.bQ.c();
        synchronized (set) {
            HashSet<PathfinderGoalWrapped> toAdd = new HashSet<PathfinderGoalWrapped>();
            HashSet<PathfinderGoalWrapped> toRemove = new HashSet<PathfinderGoalWrapped>();
            for (PathfinderGoalWrapped pgw : goals) {
                PathfinderGoal goal = pgw.k();
                Class<?> goalClass = goal.getClass();
                if (keepDedicated && !goalClass.getName().contains("ai.goal")) continue;
                if (isAnimal && module.isBreedEnabled() && goalClass == PathfinderGoalBreed.class) {
                    toRemove.add(pgw);
                    toAdd.add(new PathfinderGoalWrapped(pgw.i(), (PathfinderGoal)new OptimizedBreedGoal((EntityAnimal)handle)));
                    continue;
                }
                if (module.isTemptEnabled() && goalClass == PathfinderGoalTempt.class && temptTargeting != null) {
                    toRemove.add(pgw);
                    toAdd.add(new PathfinderGoalWrapped(pgw.i(), (PathfinderGoal)new OptimizedTemptGoal(handle, temptTargeting)));
                    continue;
                }
                String simpleName = goalClass.getSimpleName();
                if (aiList.stream().anyMatch(simpleName::contains) != aiListMode) continue;
                toRemove.add(pgw);
            }
            if (!toRemove.isEmpty()) {
                goals.removeAll(toRemove);
            }
            if (!toAdd.isEmpty()) {
                goals.addAll(toAdd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        Map<EntityCreature, Boolean> map = this.optimizedMobs;
        synchronized (map) {
            this.optimizedMobs.keySet().removeIf(ent -> !ent.bl() || !ent.valid);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLoad(EntitiesLoadEvent e) {
        if (!this.getModule().canContinue(e.getWorld())) {
            return;
        }
        if (this.getModule().isAsync()) {
            SupportManager.getInstance().getExecutor().execute(() -> this.optimizeEntities(e.getEntities()));
        } else {
            this.optimizeEntities(e.getEntities());
        }
    }

    public void optimizeEntities(List<Entity> list) {
        for (Entity entity : list) {
            if (!this.getModule().isEnabled(entity)) continue;
            this.optimize(entity, false);
        }
    }

    public class OptimizedBreedGoal
    extends PathfinderGoal {
        protected final EntityAnimal animal;
        protected EntityAnimal partner;

        public OptimizedBreedGoal(EntityAnimal entityanimal) {
            this.animal = entityanimal;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        public boolean a() {
            if (!this.animal.fF()) {
                return false;
            }
            this.partner = this.getFreePartner();
            if (this.partner == null || !this.partner.bl() || !this.partner.fF()) {
                return false;
            }
            if (MobAiReducer.this.getModule().isBreedEvent()) {
                EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent((net.minecraft.world.entity.Entity)this.animal, (EntityLiving)this.partner, (EntityTargetEvent.TargetReason)EntityTargetEvent.TargetReason.CUSTOM);
                return !event.isCancelled();
            }
            return true;
        }

        public void e() {
            if (MobAiReducer.this.getModule().isBreedTeleport()) {
                this.animal.b(this.partner.dc(), this.partner.de(), this.partner.di());
            } else {
                this.animal.D().a((net.minecraft.world.entity.Entity)this.partner, MobAiReducer.this.getModule().getBreedSpeed());
            }
            this.animal.a(this.animal.s.getMinecraftWorld(), this.partner);
        }

        private EntityAnimal getFreePartner() {
            List nearbyEntities = this.animal.s.a(this.animal.getClass(), MobAiReducer.this.breedTargeting, (EntityLiving)this.animal, this.animal.cw().g(8.0));
            return nearbyEntities.stream().filter(arg_0 -> ((EntityAnimal)this.animal).a(arg_0)).min(Comparator.comparingDouble(other -> other.f((net.minecraft.world.entity.Entity)this.animal))).orElse(null);
        }
    }

    public class OptimizedTemptGoal
    extends PathfinderGoal {
        private final EntityCreature mob;
        private final PathfinderTargetCondition targeting;
        private int cooldown = 0;
        private EntityHuman targetPlayer;

        public OptimizedTemptGoal(EntityCreature mob, PathfinderTargetCondition targeting) {
            this.mob = mob;
            this.targeting = targeting;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        public boolean a() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.targetPlayer = this.mob.s.a(this.targeting, (EntityLiving)this.mob);
            if (this.targetPlayer == null) {
                return false;
            }
            if (MobAiReducer.this.getModule().isTemptEvent()) {
                EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent((net.minecraft.world.entity.Entity)this.mob, (EntityLiving)this.targetPlayer, (EntityTargetEvent.TargetReason)EntityTargetEvent.TargetReason.TEMPT);
                return !event.isCancelled();
            }
            return true;
        }

        public void e() {
            if (this.mob.f((net.minecraft.world.entity.Entity)this.targetPlayer) >= 6.25 || MobAiReducer.this.getModule().isTemptTeleport()) {
                if (MobAiReducer.this.getModule().isTemptTeleport()) {
                    this.mob.b(this.targetPlayer.dc(), this.targetPlayer.de(), this.targetPlayer.di());
                } else {
                    this.mob.D().a((net.minecraft.world.entity.Entity)this.targetPlayer, this.mob instanceof EntityAnimal ? MobAiReducer.this.getModule().getTemptSpeed() : 0.35);
                }
            } else {
                this.mob.D().n();
            }
            this.cooldown = MobAiReducer.this.getModule().getTemptCooldown();
        }
    }
}

