/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class ColoredLogger
extends Logger {
    public ColoredLogger() {
        super(ColoredLogger.convertStringMessage("&e\u26a1"), null);
        this.setParent(Bukkit.getLogger());
        this.setLevel(Level.ALL);
    }

    private static String convertStringMessage(String message) {
        if (message != null && !message.isEmpty()) {
            Object messageCopy = String.copyValueOf(message.toCharArray()) + AnsiColor.RESET.getAnsiColor();
            Matcher matcher = Pattern.compile(String.format("(%c[0-9a-fk-or])(?!.*\u0001)", Character.valueOf('&'))).matcher(message);
            while (matcher.find()) {
                String result = matcher.group(1);
                AnsiColor color = AnsiColor.getColorByCode(result.charAt(1));
                if (color == null) continue;
                messageCopy = ((String)messageCopy).replace(result, color.getAnsiColor());
            }
            return messageCopy;
        }
        return message;
    }

    @Override
    public void log(@NotNull LogRecord logRecord) {
        logRecord.setMessage(ColoredLogger.convertStringMessage(logRecord.getMessage()));
        super.log(logRecord);
    }

    private static enum AnsiColor {
        BLACK('0', "\u001b[38;5;%dm", 0),
        DARK_GREEN('2', "\u001b[38;5;%dm", 2),
        DARK_RED('4', "\u001b[38;5;%dm", 1),
        GOLD('6', "\u001b[38;5;%dm", 172),
        DARK_GREY('8', "\u001b[38;5;%dm", 8),
        GREEN('a', "\u001b[38;5;%dm", 10),
        RED('c', "\u001b[38;5;%dm", 9),
        YELLOW('e', "\u001b[38;5;%dm", 11),
        DARK_BLUE('1', "\u001b[38;5;%dm", 4),
        DARK_AQUA('3', "\u001b[38;5;%dm", 30),
        DARK_PURPLE('5', "\u001b[38;5;%dm", 54),
        GRAY('7', "\u001b[38;5;%dm", 246),
        BLUE('9', "\u001b[38;5;%dm", 4),
        AQUA('b', "\u001b[38;5;%dm", 51),
        LIGHT_PURPLE('d', "\u001b[38;5;%dm", 13),
        WHITE('f', "\u001b[38;5;%dm", 15),
        STRIKETHROUGH('m', "\u001b[%dm", 9),
        ITALIC('o', "\u001b[%dm", 3),
        BOLD('l', "\u001b[%dm", 1),
        UNDERLINE('n', "\u001b[%dm", 4),
        RESET('r', "\u001b[%dm", 0);

        private static final Map<Character, AnsiColor> chars;
        private final char bukkitColor;
        private final String ansiColor;

        private AnsiColor(char bukkitColor, String pattern, int ansiCode) {
            this.bukkitColor = bukkitColor;
            this.ansiColor = String.format(pattern, ansiCode);
        }

        public static AnsiColor getColorByCode(char code) {
            return chars.get(Character.valueOf(code));
        }

        public char getBukkitColor() {
            return this.bukkitColor;
        }

        public String getAnsiColor() {
            return this.ansiColor;
        }

        static {
            chars = Arrays.stream(AnsiColor.values()).collect(Collectors.toMap(AnsiColor::getBukkitColor, Function.identity()));
        }
    }
}

