/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.lychee.lagfixer.ColoredLogger;
import xyz.lychee.lagfixer.managers.CommandManager;
import xyz.lychee.lagfixer.managers.ConfigManager;
import xyz.lychee.lagfixer.managers.ErrorsManager;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.managers.MetricsManager;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.MonitorManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.managers.UpdaterManager;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.utils.TimingUtil;

public class LagFixer
extends JavaPlugin {
    private static LagFixer instance;
    private final ArrayList<AbstractManager> managers = new ArrayList();
    private final Logger logger = new ColoredLogger();

    public void onEnable() {
        instance = this;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
        }
        catch (ClassNotFoundException e) {
            IntStream.range(0, 10).forEach(i -> this.getLogger().info("\nThis version of the plugin is intended only for folia servers, the correct version of the plugin can be found at:\n - https://modrinth.com/plugin/lagfixer/versions?l=bukkit\n"));
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("&fLagFixer - Best Performance Solution!&r\n&8                                                                \n&8  &e\u2588\u2588&6\u2557&8      &e\u2588\u2588\u2588\u2588\u2588&6\u2557&8  &e\u2588\u2588\u2588\u2588\u2588\u2588&6\u2557&8   &e\u2588\u2588\u2588\u2588\u2588\u2588\u2588&6\u2557&e\u2588\u2588&6\u2557&e\u2588\u2588&6\u2557&8  &e\u2588\u2588&6\u2557&e\u2588\u2588\u2588\u2588\u2588\u2588\u2588&6\u2557&e\u2588\u2588\u2588\u2588\u2588\u2588&6\u2557&8   \n&8  &e\u2588\u2588&6\u2551&8     &e\u2588\u2588&6\u2554\u2550\u2550&e\u2588\u2588&6\u2557&e\u2588\u2588&6\u2554\u2550\u2550\u2550\u2550\u255d&8   &e\u2588\u2588&6\u2554\u2550\u2550\u2550\u2550\u255d&e\u2588\u2588&6\u2551\u255a&e\u2588\u2588&6\u2557&e\u2588\u2588&6\u2554\u255d&e\u2588\u2588&6\u2554\u2550\u2550\u2550\u2550\u255d&e\u2588\u2588&6\u2554\u2550\u2550&e\u2588\u2588&6\u2557&8  \n&8  &e\u2588\u2588&6\u2551&8     &e\u2588\u2588\u2588\u2588\u2588\u2588\u2588&6\u2551&e\u2588\u2588&6\u2551&8  &e\u2588\u2588&6\u2557&8   &e\u2588\u2588\u2588\u2588\u2588&6\u2557&8  &e\u2588\u2588&6\u2551&8 &6\u255a&e\u2588\u2588\u2588&6\u2554\u255d&8 &e\u2588\u2588\u2588\u2588\u2588&6\u2557&8  &e\u2588\u2588\u2588\u2588\u2588\u2588&6\u2554\u255d&8  \n&8  &e\u2588\u2588&6\u2551&8     &e\u2588\u2588&6\u2554\u2550\u2550&e\u2588\u2588&6\u2551&e\u2588\u2588&6\u2551&8  &6\u255a&e\u2588\u2588&6\u2557&8  &e\u2588\u2588&6\u2554\u2550\u2550\u255d&8  &e\u2588\u2588&6\u2551&8 &e\u2588\u2588&6\u2554&e\u2588\u2588&6\u2557&8 &e\u2588\u2588&6\u2554\u2550\u2550\u255d&8  &e\u2588\u2588&6\u2554\u2550\u2550&e\u2588\u2588&6\u2557&8  \n&8  &e\u2588\u2588\u2588\u2588\u2588\u2588\u2588&6\u2557&e\u2588\u2588&6\u2551&8  &e\u2588\u2588&6\u2551\u255a&e\u2588\u2588\u2588\u2588\u2588\u2588&6\u2554\u255d&8  &e\u2588\u2588&6\u2551&8     &e\u2588\u2588&6\u2551&e\u2588\u2588&6\u2554\u255d\u255a&e\u2588\u2588&6\u2557&e\u2588\u2588\u2588\u2588\u2588\u2588\u2588&6\u2557&e\u2588\u2588&6\u2551&8  &e\u2588\u2588&6\u2551&8  \n&8                                                                  ");
        this.managers.clear();
        this.loadManager(new ErrorsManager(this));
        this.loadManager(new SupportManager(this));
        this.loadManager(new ConfigManager(this));
        this.loadManager(new HookManager(this));
        this.loadManager(new MonitorManager(this));
        this.loadManager(new MetricsManager(this));
        this.loadManager(new UpdaterManager(this));
        this.loadManager(new ModuleManager(this));
        this.loadManager(new CommandManager(this));
        this.getLogger().info("&fRemember to leave a rating!&r &e&l\u2605 \u2605 \u2605 \u2605 \u2605");
    }

    public void onDisable() {
        Iterator<AbstractManager> it = this.managers.iterator();
        while (it.hasNext()) {
            AbstractManager manager = it.next();
            try {
                this.getLogger().info("&8(&e" + manager.getClass().getSimpleName() + "&8) &7-> &fDisabling manager...");
                TimingUtil t = TimingUtil.startNew();
                manager.disable();
                this.getLogger().info("&8(&e" + manager.getClass().getSimpleName() + "&8) &7-> &fDisabled manager in &e" + t.stop().getExecutingTime() + "ms&f!");
            }
            catch (Exception ex) {
                this.printError(ex);
            }
            it.remove();
        }
        Bukkit.getAsyncScheduler().cancelTasks((Plugin)this);
        Bukkit.getGlobalRegionScheduler().cancelTasks((Plugin)this);
        HandlerList.unregisterAll((Plugin)this);
    }

    public void loadManager(AbstractManager manager) {
        if (!manager.isEnabled()) {
            return;
        }
        this.managers.add(manager);
        try {
            this.getLogger().info("&8(&e" + manager.getClass().getSimpleName() + "&8) &7-> &fEnabling manager...");
            TimingUtil t = TimingUtil.startNew();
            manager.load();
            this.getLogger().info("&8(&e" + manager.getClass().getSimpleName() + "&8) &7-> &fEnabled manager in &e" + t.stop().getExecutingTime() + "ms&f!");
        }
        catch (Exception ex) {
            this.printError(ex);
        }
    }

    public void printError(Throwable ex) {
        if (ErrorsManager.getInstance() != null && ErrorsManager.getInstance().checkError(ex)) {
            this.getLogger().log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public ArrayList<AbstractManager> getManagers() {
        return this.managers;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static LagFixer getInstance() {
        return instance;
    }
}

