/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.stream.Streams;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import xyz.lychee.lagfixer.managers.CommandManager;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.modules.WorldCleanerModule;
import xyz.lychee.lagfixer.objects.RegionsEntityRaport;
import xyz.lychee.lagfixer.utils.MessageUtils;

public class ClearCommand
extends CommandManager.Subcommand {
    public ClearCommand(CommandManager commandManager) {
        super(commandManager, "clear", "clear entities using rules in WorldCleaner", new String[0]);
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String[] args) {
        String type;
        if (args.length < 1) {
            MessageUtils.sendMessage(true, sender, "&7Usage: &f/lagfixer clear <items|creatures|projectiles>");
            return true;
        }
        WorldCleanerModule module = ModuleManager.getInstance().get(WorldCleanerModule.class);
        if (module == null || !module.isLoaded()) {
            MessageUtils.sendMessage(true, sender, "&7WorldCleaner module is disabled!");
            return true;
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        RegionsEntityRaport raport = new RegionsEntityRaport();
        LongAdder size = raport.getEntities();
        switch (type = args[0].toLowerCase()) {
            case "items": {
                for (World w : module.getAllowedWorlds()) {
                    module.getWorldCleaner().purgeItems(w, futures, size);
                }
                break;
            }
            case "creatures": {
                for (World w : module.getAllowedWorlds()) {
                    module.getWorldCleaner().purgeCreatures(w, futures, size);
                }
                break;
            }
            case "projectiles": {
                for (World w : module.getAllowedWorlds()) {
                    module.getWorldCleaner().purgeProjectiles(w, futures, size);
                }
                break;
            }
            case "all": {
                for (World w : module.getAllowedWorlds()) {
                    module.getWorldCleaner().purgeAll(w, futures, raport);
                }
                break;
            }
            default: {
                return MessageUtils.sendMessage(true, sender, "&7Invalid clear type: &f" + type);
            }
        }
        MessageUtils.sendMessage(true, sender, "&7Asynchronous entity removal in progress...");
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).orTimeout(5L, TimeUnit.SECONDS).whenComplete((v, t) -> MessageUtils.sendMessage(true, sender, "&7Successfully removed &e" + String.valueOf(size) + " &7entities!"));
        return true;
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] args) {
        if (args.length == 1) {
            return Streams.of((Object[])new String[]{"items", "creatures", "projectiles", "all"}).filter(str -> str.startsWith(args[0])).toList();
        }
        return Collections.emptyList();
    }
}

